<?php $form=$this->beginWidget('bootstrap.widgets.TbActiveForm',array(
    'id'=>'gate-set-form',
    'enableAjaxValidation'=>false,
)); ?>

<p class="help-block">
  Fields with <span class="required">*</span> are required.
</p>

<?php echo $form->errorSummary($model); ?>

<?php echo $form->textFieldRow($model,'name',array('class'=>'span5','maxlength'=>255)); ?>

<?php echo $form->textFieldRow($model,'description',array('class'=>'span5','maxlength'=>255)); ?>

<table class="table table.condensed">
  <thead>
    <tr>
      <th><?php echo t('Group'); ?></th>
      <th><?php echo t('Gate'); ?></th>
      <th><?php echo t('Selected'); ?></th>
    </tr>
  </thead>
  <tbody>
    <?php
    $owned = array();
    foreach($model->gates as $gt)
      $owned[intval($gt->ID)] = "ok";

    foreach(Gate::getAllGates() as $gate)
    {
      echo("<tr>");
      echo("<td>{$gate->gateGroup->name}</td>");
      echo("<td>$gate->Descrizione</td>");
      echo("<td>".CHtml::checkBox("Gates[{$gate->ID}]",array_key_exists($gate->ID, $owned))."</td>");
      echo("</tr>");
    }
    ?>
  </tbody>
</table>

<div class="form-actions">
  <?php $this->widget('bootstrap.widgets.TbButton', array(
      'buttonType'=>'submit',
      'type'=>'primary',
      'label'=>$model->isNewRecord ? 'Create' : 'Save',
		)); ?>
</div>

<?php $this->endWidget(); ?>
