<div class="page-header">
  <h2>
    <li class="icon-bug"></li>
    <?php echo htmlspecialchars(t("Debug"),ENT_QUOTES,'UTF-8'); ?>
    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'pull-right'), array('href', (Yii::app()->createUrl('debug/DisableDebug'))), array('title', (t('Leave Debug Mode')))), 'html5', 'UTF-8'); ?>>
      <div class="icon-signout"></div>
    </a>
  </h2>
</div>
<span8>
  <form <?php echo MtHaml\Runtime::renderAttributes(array(array('method', 'POST'), array('action', (url('debug/console')))), 'html5', 'UTF-8'); ?>>
    <label for="fast_command"><?php echo htmlspecialchars('Fast Command: ',ENT_QUOTES,'UTF-8'); ?></label>
    <input id="fast_command" name="command" type="text" style="width: 80%;" />
    <input type="submit" />
  </form>
</span8>
<span8>
  <form <?php echo MtHaml\Runtime::renderAttributes(array(array('method', 'POST'), array('action', (url('debug/query')))), 'html5', 'UTF-8'); ?>>
    <label for="fast_query"><?php echo htmlspecialchars('Fast Query: ',ENT_QUOTES,'UTF-8'); ?></label>
    <input id="fast_query" name="query" type="text" style="width: 80%;" />
    <input type="submit" />
  </form>
</span8>
<span8>
  <table>
    <tr>
      <td>
        <div class="span3">
          <div class="admin-menu-container span3">
            <div class="admin-menu-title">
              <?php echo htmlspecialchars(t("GUI Management"),ENT_QUOTES,'UTF-8'); ?>
            </div>
            <section>
              <span class="title">
                <?php echo htmlspecialchars('HOST: '.getDbHost(),ENT_QUOTES,'UTF-8'); ?>
              </span>
            </section>
            <section>
              <span class="title">
                <?php echo htmlspecialchars('DB: '.getDbName(),ENT_QUOTES,'UTF-8'); ?>
              </span>
            </section>
            <section>
              <span class="title">
                <?php echo htmlspecialchars('USER: '.getDbUser(),ENT_QUOTES,'UTF-8'); ?>
              </span>
            </section>
            <section>
              <span class="title">
                <?php echo htmlspecialchars('URL: '.paramdeep('photoBaseUrl')." (".(paramdeep('photoBaseLocationByUrl')?'true':'false').")",ENT_QUOTES,'UTF-8'); ?>
                <br />
                <?php echo htmlspecialchars('PATH: '.paramdeep('photoBasePath'),ENT_QUOTES,'UTF-8'); ?>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/runtime_config')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(Yii::t("app", "Runtime configuration"),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/loggers')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(Yii::t("app", "Loggers"),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/dynconfig')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(Yii::t("app", "Debug configuration")                  ,ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/cleanRuntime'))), array('onclick', ('return confirm(\'' . (t('Confirm operation?')) . '\');'))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(t('Clean runtime'),ENT_QUOTES,'UTF-8'); ?>
                  <?php $runtimeSize = DebugController::getRuntimeSize(); ?>
                  <?php if(!empty($runtimeSize)) { ?>
                    <?php echo htmlspecialchars(" ($runtimeSize)",ENT_QUOTES,'UTF-8'); ?>
                  <?php } ?>
                </a>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/migrations')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(Yii::t("app", "Migrations"),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/translations')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(Yii::t("app", "Translations"),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
            <?php if(user()->checkAccess('plateauthinsertprofile_management'))   { ?>
              <section>
                <span class="title">
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('PlateAuthInsertProfile/admin')))), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars(t('Manage Plate Auth Insert Profiles'),ENT_QUOTES,'UTF-8'); ?>
                  </a>
                </span>
              </section>
            <?php } ?>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('api/playground')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(t('API playground'),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
          </div>
        </div>
      </td>
      <td>
        <div class="span3">
          <div class="admin-menu-container span3">
            <div class="admin-menu-title">
              <?php echo htmlspecialchars(t("Remote Administration"),ENT_QUOTES,'UTF-8'); ?>
            </div>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/fileExplorer')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(t('File Explorer'),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/console')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(t('Console'),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
            <?php $appLogFilename = pathCombine(app()->basePath, 'runtime/application.log'); ?>
            <section>
              <span <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'title'), array('title', $appLogFilename)), 'html5', 'UTF-8'); ?>>
                <?php if(fileExists($appLogFilename)) { ?>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/viewAsText', array('filename'=>$appLogFilename))))), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars(t('Application Log'),ENT_QUOTES,'UTF-8'); ?>
                  </a>
                <?php } else { ?>
                  <?php echo htmlspecialchars(t('Application Log'),ENT_QUOTES,'UTF-8'); ?>
                <?php } ?>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/logs')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(t('Logs'),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
            <section>
              <span class="title">
                <?php if(DebugHelper::toolExists('schtasks')) { ?>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/scheduledTasks')))), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars(t('Scheduled Tasks'),ENT_QUOTES,'UTF-8'); ?>
                  </a>
                  <span class="color-green"><?php echo htmlspecialchars(t('Found'),ENT_QUOTES,'UTF-8'); ?></span>
                <?php } else { ?>
                  <?php echo htmlspecialchars(t('Scheduled Tasks'),ENT_QUOTES,'UTF-8'); ?>
                  <span class="color-red"><?php echo htmlspecialchars(t('Not found'),ENT_QUOTES,'UTF-8'); ?></span>
                <?php } ?>
              </span>
            </section>
            <section>
              <span class="title">
                <?php if(DebugHelper::toolExists('tasklist')) { ?>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/processes')))), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars(t('Processes'),ENT_QUOTES,'UTF-8'); ?>
                  </a>
                  <span class="color-green"><?php echo htmlspecialchars(t('Found'),ENT_QUOTES,'UTF-8'); ?></span>
                <?php } else { ?>
                  <?php echo htmlspecialchars(t('Processes'),ENT_QUOTES,'UTF-8'); ?>
                  <span class="color-red"><?php echo htmlspecialchars(t('Not found'),ENT_QUOTES,'UTF-8'); ?></span>
                <?php } ?>
              </span>
            </section>
            <section>
              <span class="title">
                <?php if(DebugHelper::toolExists('sc')) { ?>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/services')))), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars(t('Services'),ENT_QUOTES,'UTF-8'); ?>
                  </a>
                  <span class="color-green"><?php echo htmlspecialchars(t('Found'),ENT_QUOTES,'UTF-8'); ?></span>
                <?php } else { ?>
                  <?php echo htmlspecialchars(t('Services'),ENT_QUOTES,'UTF-8'); ?>
                  <span class="color-red"><?php echo htmlspecialchars(t('Not found'),ENT_QUOTES,'UTF-8'); ?></span>
                <?php } ?>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/UserTrackingIndex')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(t('User Tracking'),ENT_QUOTES,'UTF-8'); ?>
                </a>
                <?php if(paramdeep('security','user_tracking','enabled')) { ?>
                  <div class="icon-off" style="color: green;"></div>
                <?php } else { ?>
                  <div class="icon-off" style="color: red;"></div>
                <?php } ?>
                <?php echo htmlspecialchars(" (".formatBytes(DebugHelper::getTableSize('user_tracking_table')).")",ENT_QUOTES,'UTF-8'); ?>
              </span>
            </section>
          </div>
        </div>
      </td>
      <td>
        <div class="span3">
          <div class="admin-menu-container span3">
            <div class="admin-menu-title">
              <?php echo htmlspecialchars(t("Test"),ENT_QUOTES,'UTF-8'); ?>
            </div>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/test_impersonate')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(t("Impersonate"),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/test_createNotification')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(t("Create Test Notification"),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/FlashMessages')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(Yii::t("app", "Flash messages"),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
          </div>
        </div>
      </td>
      <td>
        <div class="span3">
          <div class="admin-menu-container span3">
            <div class="admin-menu-title">
              <?php echo htmlspecialchars(t("Models"),ENT_QUOTES,'UTF-8'); ?>
            </div>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('gii')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars("Gii",ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/model_create')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(t("Create"),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/model_edit')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(t("Edit"),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/model_createRelation')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars("Create relation",ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
          </div>
        </div>
      </td>
    </tr>
    <tr>
      <td>
        <div class="span3">
          <div class="admin-menu-container span3">
            <div class="admin-menu-title">
              <?php echo htmlspecialchars(t("PHP")." (".call_func('phpversion', array(), t('Not found')).")",ENT_QUOTES,'UTF-8'); ?>
            </div>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/phpinfo')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(t('PHP Info'),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/eval')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(t('Evaluate PHP code'),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/phpFunctions')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(t('Functions'),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
            <section>
              <span class="title">
                <?php $phpIni = DebugHelper::php_getIniPath(); ?>
                <?php if(fileExists($phpIni)) { ?>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/viewAsText',array('filename'=>$phpIni))))), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars(t('PHP.ini'),ENT_QUOTES,'UTF-8'); ?>
                  </a>
                  <span class="color-green"><?php echo htmlspecialchars(t('Found'),ENT_QUOTES,'UTF-8'); ?></span>
                <?php } else { ?>
                  <?php echo htmlspecialchars(t('PHP.ini'),ENT_QUOTES,'UTF-8'); ?>
                  <span class="color-red"><?php echo htmlspecialchars(t('Not found'),ENT_QUOTES,'UTF-8'); ?></span>
                <?php } ?>
              </span>
            </section>
            <section>
              <span class="title">
                <?php echo htmlspecialchars(t('PHP.exe'),ENT_QUOTES,'UTF-8'); ?>
                <?php $phpExe = DebugHelper::php_getExePath(); ?>
                <?php if(fileExists($phpExe)) { ?>
                  <span class="color-green"><?php echo htmlspecialchars(t('Found'),ENT_QUOTES,'UTF-8'); ?></span>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/fileExplorer',array('path'=>dirname($phpExe)))))), 'html5', 'UTF-8'); ?>>
                    <span class="icon-folder-open-alt"></span>
                  </a>
                <?php } else { ?>
                  <span class="color-red"><?php echo htmlspecialchars(t('Not found'),ENT_QUOTES,'UTF-8'); ?></span>
                <?php } ?>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/PhpExtensions')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(t('Extensions'),ENT_QUOTES,'UTF-8'); ?>
                </a>
                <?php $extPhpPath = DebugHelper::php_getExtensionFolderPath(); ?>
                <?php if(dirExists($extPhpPath)) { ?>
                  <span class="color-green"><?php echo htmlspecialchars(t('Found'),ENT_QUOTES,'UTF-8'); ?></span>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/fileExplorer',array('path'=>$extPhpPath))))), 'html5', 'UTF-8'); ?>>
                    <span class="icon-folder-open-alt"></span>
                  </a>
                <?php } else { ?>
                  <span class="color-red"><?php echo htmlspecialchars(t('Not found'),ENT_QUOTES,'UTF-8'); ?></span>
                <?php } ?>
              </span>
            </section>
          </div>
        </div>
      </td>
      <td>
        <?php $apacheServiceName=DebugHelper::apache_getServiceName(); ?>
        <?php $apachePath=DebugHelper::apache_getPath(); ?>
        <div class="span3">
          <div class="admin-menu-container span3">
            <div class="admin-menu-title">
              <?php echo htmlspecialchars(t("Apache"),ENT_QUOTES,'UTF-8'); ?>
            </div>
            <section>
              <span class="title">
                <?php echo htmlspecialchars("SERVICE:",ENT_QUOTES,'UTF-8'); ?>
                <?php if(!isEmpty($apacheServiceName)) { ?>
                  <?php if(!isEmpty($apachePath)) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/fileExplorer',array('path'=>$apachePath))))), 'html5', 'UTF-8'); ?>>
                      <span class="color-blue"><?php echo htmlspecialchars($apacheServiceName,ENT_QUOTES,'UTF-8'); ?></span>
                    </a>
                  <?php } else { ?>
                    <span class="color-blue"><?php echo htmlspecialchars($apacheServiceName,ENT_QUOTES,'UTF-8'); ?></span>
                  <?php } ?>
                  <span class="color-green"><?php echo htmlspecialchars(t('Found'),ENT_QUOTES,'UTF-8'); ?></span>
                <?php } else { ?>
                  <span class="color-red"><?php echo htmlspecialchars(t('Not found'),ENT_QUOTES,'UTF-8'); ?></span>
                <?php } ?>
              </span>
            </section>
            <?php if(!isEmpty($apachePath)) { ?>
              <?php $conf=DebugHelper::apache_getConfigPath(); ?>
              <?php if(!isEmpty($conf)) { ?>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/viewAsText',array('filename'=>$conf))))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t('Configuration'),ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </span>
                </section>
              <?php } ?>
            <?php } ?>
            <?php if(!isEmpty($apacheServiceName)) { ?>
              <section>
                <span class="title">
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/apache_restart')))), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars(t('Restart'),ENT_QUOTES,'UTF-8'); ?>
                  </a>
                </span>
              </section>
            <?php } ?>
          </div>
        </div>
      </td>
      <td>
        <?php $mysqlServiceName=DebugHelper::mysql_getServiceName(); ?>
        <?php $mysqlPath=DebugHelper::mysql_getPath(); ?>
        <div class="span3">
          <div class="admin-menu-container span3">
            <div class="admin-menu-title">
              <?php echo htmlspecialchars(t("MySQL"),ENT_QUOTES,'UTF-8'); ?>
            </div>
            <section>
              <span class="title">
                <?php echo htmlspecialchars("SERVICE:",ENT_QUOTES,'UTF-8'); ?>
                <?php if(!isEmpty($mysqlServiceName)) { ?>
                  <?php if(!isEmpty($mysqlPath)) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/fileExplorer',array('path'=>$mysqlPath))))), 'html5', 'UTF-8'); ?>>
                      <span class="color-blue"><?php echo htmlspecialchars($mysqlServiceName,ENT_QUOTES,'UTF-8'); ?></span>
                    </a>
                  <?php } else { ?>
                    <span class="color-blue"><?php echo htmlspecialchars($mysqlServiceName,ENT_QUOTES,'UTF-8'); ?></span>
                  <?php } ?>
                  <span class="color-green"><?php echo htmlspecialchars(t('Found'),ENT_QUOTES,'UTF-8'); ?></span>
                <?php } else { ?>
                  <span class="color-red"><?php echo htmlspecialchars(t('Not found'),ENT_QUOTES,'UTF-8'); ?></span>
                <?php } ?>
              </span>
            </section>
            <?php if(!isEmpty($mysqlServiceName)) { ?>
              <?php if(!isEmpty($mysqlPath)) { ?>
                <?php $conf=DebugHelper::mysql_getConfigPath(); ?>
                <?php if(!isEmpty($conf)) { ?>
                  <section>
                    <span class="title">
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/viewAsText',array('filename'=>$conf))))), 'html5', 'UTF-8'); ?>>
                        <?php echo htmlspecialchars(t('Configuration'),ENT_QUOTES,'UTF-8'); ?>
                      </a>
                    </span>
                  </section>
                <?php } ?>
              <?php } ?>
              <section>
                <span class="title">
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/mysql_restart')))), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars(t('Restart'),ENT_QUOTES,'UTF-8'); ?>
                  </a>
                </span>
              </section>
            <?php } ?>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/query')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(t('Query'),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/DbRepairTable')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(t('Repair'),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
            <section>
              <span class="title">
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/MysqlProcessList')))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(t('Process List'),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </span>
            </section>
          </div>
        </div>
      </td>
      <td>
        <div class="span3">
          <div class="admin-menu-container span3">
            <div class="admin-menu-title">
              <?php echo htmlspecialchars(t("KNowP"),ENT_QUOTES,'UTF-8'); ?>
            </div>
            <section>
              <span class="title">
                <small>
                  <span><?php echo htmlspecialchars('ID:',ENT_QUOTES,'UTF-8'); ?></span>
                  <span class="color-blue"><?php echo htmlspecialchars(KNowPHelper::getInstallationId(),ENT_QUOTES,'UTF-8'); ?></span>
                </small>
              </span>
            </section>
          </div>
        </div>
      </td>
    </tr>
  </table>
</span8>
<center class="color-blue">
  <?php echo "PID: ".call_func('getmypid', array(), "getmypid: ".t('Not found')); ?>
</center>
<center class="color-blue">
  <?php echo call_func('php_uname', array(), "php_uname: ".t('Not found')); ?>
</center>
<center class="color-blue">
  <?php echo call_func('apache_get_version', array(), "apache_get_version: ".t('Not found')); ?>
</center>
<center class="color-blue">
  <?php if(check_internet_connection("www.google.com",80,2)) { ?>
    <?php echo htmlspecialchars('CONNECTED to The Internet',ENT_QUOTES,'UTF-8'); ?>
  <?php } else { ?>
    <?php echo htmlspecialchars('NOT CONNECTED The Internet',ENT_QUOTES,'UTF-8'); ?>
  <?php } ?>
</center>
<center class="color-blue">
  <?php echo htmlspecialchars(".NET x86:",ENT_QUOTES,'UTF-8'); ?>
  <?php foreach(DebugHelper::getDotNetFrameworks(false) as $dot) { ?>
    <?php if($dot->hasCompiler()) { ?>
      <a href="#"><?php echo htmlspecialchars($dot,ENT_QUOTES,'UTF-8'); ?></a>
    <?php } else { ?>
      <?php echo htmlspecialchars($dot,ENT_QUOTES,'UTF-8'); ?>
    <?php } ?>
  <?php } ?>
</center>
<center class="color-blue">
  <?php echo htmlspecialchars(".NET x64:",ENT_QUOTES,'UTF-8'); ?>
  <?php foreach(DebugHelper::getDotNetFrameworks(true) as $dot) { ?>
    <?php if($dot->hasCompiler()) { ?>
      <a href="#"><?php echo htmlspecialchars($dot,ENT_QUOTES,'UTF-8'); ?></a>
    <?php } else { ?>
      <?php echo htmlspecialchars($dot,ENT_QUOTES,'UTF-8'); ?>
    <?php } ?>
  <?php } ?>
</center>
