<?php if(!isset($pagination) || $pagination == false)                                                { ?>
  <p><?php echo htmlspecialchars(t('Last {0} sessions', array('{0}'=>count($workPeriods)))                                                                     ,ENT_QUOTES,'UTF-8'); ?></p>
<?php } ?>
<div class="report-table-container">
  <table class="table table-striped table-condensed">
    <thead>
      <tr>
        <th></th>
        <th><?php echo htmlspecialchars(t('Session'),ENT_QUOTES,'UTF-8'); ?></th>
        <?php if($all) { ?>
          <th><?php echo htmlspecialchars(t('User'),ENT_QUOTES,'UTF-8'); ?></th>
        <?php } ?>
        <th><?php echo htmlspecialchars(t('Start'),ENT_QUOTES,'UTF-8'); ?></th>
        <th><?php echo htmlspecialchars(t('End'),ENT_QUOTES,'UTF-8'); ?></th>
        <th><?php echo htmlspecialchars(t('Period'),ENT_QUOTES,'UTF-8'); ?></th>
        <?php if(paramdeep('payslip','showButton')) { ?>
          <th><?php echo htmlspecialchars(t('Slip'),ENT_QUOTES,'UTF-8'); ?></th>
        <?php } ?>
        <?php if (Yii::app()->user->checkAccess('create_events_report')) { ?>
          <th><?php echo htmlspecialchars(t('Report'),ENT_QUOTES,'UTF-8'); ?></th>
        <?php } ?>
      </tr>
    </thead>
    <tbody>
      <?php foreach($workPeriods as $workPeriod) { ?>
        <?php $this->renderPartial('/dashboard/workPeriod/_eventsReportRow',get_defined_vars()); ?>
      <?php } ?>
    </tbody>
  </table>
  <div class="row">
    <?php if((!isset($pagination) || $pagination == false) && user()->checkAccess('work_period_view_all')) { ?>
      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-small' . ' ' . 'pull-right' . ' ' . 'btn-workperiod-details')), array('href', (Yii::app()->createAbsoluteUrl('workPeriod/all')))), 'html5', 'UTF-8'); ?>>
        <?php echo htmlspecialchars(Yii::t('app', 'Details for all users')   ,ENT_QUOTES,'UTF-8'); ?>
      </a>
    <?php } ?>
    <?php if(!isset($pagination) || $pagination == false) { ?>
      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-small' . ' ' . 'pull-right' . ' ' . 'btn-workperiod-details')), array('href', (Yii::app()->createAbsoluteUrl('workPeriod/index')))), 'html5', 'UTF-8'); ?>>
        <?php echo htmlspecialchars(Yii::t('app', 'more..')   ,ENT_QUOTES,'UTF-8'); ?>
      </a>
    <?php } ?>
  </div>
</div>
<div id="modal-payslip-confirm" class="modal hide fade"></div>
<div id="modal-report-detail" class="modal hide fade"></div>
<div id="modal-report-confirm" class="modal hide fade"></div>
