<!DOCTYPE html>
<?php $app = Yii::app(); ?>
<?php $baseUrl = $app->request->baseUrl; ?>
<?php $environment = $app->params['environment']; ?>
<?php new JsTrans('app', $app->language); ?>
<html>
  <head>
    <meta http-equiv="Content-type" content="text/html; charset=UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="X-UA-Compatible" content="chrome=1" />
    <?php $app->bootstrap->register() #it must be before %title; ?>
    <title><?php echo htmlspecialchars($this->pageTitle,ENT_QUOTES,'UTF-8'); ?></title>
    <link <?php echo MtHaml\Runtime::renderAttributes(array(array('rel', 'stylesheet'), array('type', 'text/css'), array('href', ($baseUrl . '/css/application.min.css'))), 'html5', 'UTF-8'); ?> />
    <link <?php echo MtHaml\Runtime::renderAttributes(array(array('rel', 'stylesheet'), array('type', 'text/css'), array('href', ($baseUrl . '/css/custom.css'))), 'html5', 'UTF-8'); ?> />
    <link <?php echo MtHaml\Runtime::renderAttributes(array(array('rel', 'shortcut icon'), array('href', ($baseUrl . '/favicon.ico'))), 'html5', 'UTF-8'); ?> />
    <script>
      var settings = {                baseUrl: "<?php echo htmlspecialchars($baseUrl,ENT_QUOTES,'UTF-8'); ?>",language: "<?php echo htmlspecialchars($app->language,ENT_QUOTES,'UTF-8'); ?>",environment: "<?php echo htmlspecialchars($environment,ENT_QUOTES,'UTF-8'); ?>",datetimepicker_format: "<?php echo htmlspecialchars($app->params['datetimeselect_format'][$app->language]['view'],ENT_QUOTES,'UTF-8'); ?>",timepicker_format: "<?php echo htmlspecialchars($app->params['timeselect_format'][$app->language]['view'],ENT_QUOTES,'UTF-8'); ?>",dayofyearpicker_format: "<?php echo htmlspecialchars($app->params['dayoftheyearselect_format'][$app->language]['view'],ENT_QUOTES,'UTF-8'); ?>"}
    </script>
    <!--[if lt IE 9]>
      <script <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text/javascript'), array('src', ($baseUrl . '/js/html5shiv.js'))), 'html5', 'UTF-8'); ?>></script>
      <script <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text/javascript'), array('src', ($baseUrl . '/js/respond.min.js'))), 'html5', 'UTF-8'); ?>></script>
    <![endif]-->
    <script <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text/javascript'), array('src', ($baseUrl . '/js/application.min.js'))), 'html5', 'UTF-8'); ?>></script>
    <script <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text/javascript'), array('src', ($baseUrl . '/js/openseadragon.min.js'))), 'html5', 'UTF-8'); ?>></script>
    <?php if(DebugController::isInDebugMode() || user()->checkAccess('context_menu_enabled')) { ?>
      <script type="text/javascript">
        <?php echo "document.oncontextmenu = function() { return true; }; "; ?>
      </script>
    <?php } else { ?>
      <script type="text/javascript">
        <?php echo "document.oncontextmenu = function() { return false; }; "; ?>
      </script>
    <?php } ?>
  </head>
  <body>
    <?php DebugController::initDebugUser(); ?>
    <header>
      <?php if(MaintenanceModeController::userCanSee()) { ?>
        <?php $this->renderPartial("//layouts/_header"); ?>
      <?php } ?>
    </header>
    <div class="container">
      <div class="breadcrumbs">
        <?php if(isset($this->breadcrumbs)) { ?>
          <?php $this->widget('bootstrap.widgets.TbBreadcrumbs', array('links' => $this->breadcrumbs)); ?>
        <?php } ?>
      </div>
      <div id="content" style="top: 40px; position: relative; padding-bottom: 40px;">
        <div id="flash-container">
          <?php $flashMessages = Yii::app()->user->getFlashes();; ?>
          <?php if ($flashMessages) { ?>
            <?php foreach($flashMessages as $flash) { ?>
              <div <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'alert'), array('class', ('alert-' . ($flash->level)))), 'html5', 'UTF-8'); ?>>
                <div <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'icon-time'), array('title', ($flash->timestamp))), 'html5', 'UTF-8'); ?>></div>
                <?php if(!$flash->permanent) { ?>
                  <button class="close" type="button" data-dismiss="alert">&times;</button>
                <?php } ?>
                <span class="message"><?php echo $flash->content; ?></span>
              </div>
            <?php } ?>
          <?php } ?>
        </div>
        <?php echo $content; ?>
      </div>
      <?php if(MaintenanceModeController::userCanSee()) { ?>
        <?php if(paramdeep('notification','enabled') && !user()->isGuest && user()->checkAccess('notification')) { ?>
          <?php $this->renderPartial('//shared/_notification'); ?>
        <?php } ?>
      <?php } ?>
    </div>
    <footer>
      <?php $this->renderPartial("//layouts/_footer"); ?>
    </footer>
  </body>
</html>
