<?php $canSeeBlack = user()->checkAccess('blacklist_visibility'); ?>
<?php $canSeeWhite = user()->checkAccess('whitelist_visibility'); ?>
<?php $canSeeAll = $canSeeBlack && $canSeeWhite; ?>
<?php $canSee = $canSeeBlack || $canSeeWhite; ?>
<?php if(!$canSee) { ?>
  <?php access_denied_check(null,true); ?>
<?php } ?>
<?php $form=$this->beginWidget('bootstrap.widgets.TbActiveForm',array(   'id'=>'plate-list-form','enableAjaxValidation'=>false,'htmlOptions'=>array('enctype' => 'multipart/form-data'),));; ?>
<p>
  <?php echo htmlspecialchars(t('Fields with '),ENT_QUOTES,'UTF-8'); ?>
  <span class="required">*</span>
  <?php echo htmlspecialchars(t(' are required.'),ENT_QUOTES,'UTF-8'); ?>
</p>
<?php if($model->isNewRecord) { ?>
  <?php if($canSeeAll) { ?>
    <?php echo $form->dropDownListRow($model,'mode',PlateList::getModeList(),array('class'=>'span5')); ?>
  <?php } else { ?>
    <?php if($canSeeBlack) { ?>
      <?php $model->mode = PlateList::MODE_BLACK_LIST; ?>
    <?php } else { ?>
      <?php $model->mode = PlateList::MODE_WHITE_LIST; ?>
    <?php } ?>
    <?php echo $form->textFieldRow($model,'mode',array('class'=>'span5','maxlength'=>255,'readonly'=>'readonly')); ?>
  <?php } ?>
<?php } else { ?>
  <?php echo $form->textFieldRow($model,'mode',array('class'=>'span5','maxlength'=>255,'readonly'=>'readonly')); ?>
<?php } ?>
<?php echo $form->textFieldRow($model,'name',array('class'=>'span5','maxlength'=>255)); ?>
<?php echo $form->textFieldRow($model,'title',array('class'=>'span5','maxlength'=>255)); ?>
<?php echo $form->textFieldRow($model,'source',array('class'=>'span5','maxlength'=>255)); ?>
<?php if($model->isNewRecord) { ?>
  <?php echo $form->textFieldRow($model,'code',array('class'=>'span5')); ?>
<?php } else { ?>
  <?php echo $form->textFieldRow($model,'code',array('class'=>'span5','readonly'=>'readonly')); ?>
<?php } ?>
<?php echo $form->checkboxRow($model,'auto_import'); ?>
<?php echo $form->dropDownListRow($model,'import_type',PlateList::getImportType(), array('class'=>'span5')); ?>
<?php echo $form->textFieldRow($model,'import_folder',array('class'=>'span5','maxlength'=>255)); ?>
<?php echo $form->checkboxRow($model,'editable'); ?>
<?php if(user()->checkAccess('view_hidden_plate_list')) { ?>
  <?php echo $form->checkboxRow($model,'visible', array('id'=>'plate_list_visible')); ?>
<?php } else { ?>
  <input id="plate_list_visible" name="PlateList[visible]" value="1" checked="checked" type="hidden" />
<?php } ?>
<?php echo $form->checkboxRow($model,'downloadable'); ?>
<?php echo $form->checkboxRow($model,'autoconfirm'); ?>
<?php echo $form->textFieldRow($model,'autoconfirm_wait',array('class'=>'span5','maxlength'=>255)); ?>
<?php echo $form->textFieldRow($model,'mintime',array('class'=>'span5','maxlength'=>255)); ?>
<?php echo $form->textFieldRow($model,'maxtime',array('class'=>'span5','maxlength'=>255)); ?>
<?php echo $form->textFieldRow($model,'maxsize',array('class'=>'span5')); ?>
<?php echo $form->fileFieldRow($model,'image',array('class'=>'span5','maxlength'=>255)); ?>
<?php $imgurl = $model->getImageUrl(); ?>
<?php if(!empty($imgurl)) { ?>
  <br />
  <img <?php echo MtHaml\Runtime::renderAttributes(array(array('src', $imgurl), array('width', '200')), 'html5', 'UTF-8'); ?> />
  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createAbsoluteUrl('plateList/removeImage', array('id'=>$model->id))))), 'html5', 'UTF-8'); ?>>
    <?php echo htmlspecialchars(t('Remove').' [x]',ENT_QUOTES,'UTF-8'); ?>
  </a>
<?php } ?>
<div class="form-actions">
  <?php $this->widget('bootstrap.widgets.TbButton', array(            'buttonType'=>'submit','type'=>'primary','label'=>$model->isNewRecord ? t('Create') : t('Save'),));; ?>
</div>
<?php $this->endWidget(); ?>
