<div id="administration-page">
  <?php $user = Yii::app()->user; ?>
  <?php $app = Yii::app(); ?>
  <div class="page-header">
    <h2>
      <li class="icon-cog"></li>
      <?php echo htmlspecialchars(Yii::t("app", "Administration"),ENT_QUOTES,'UTF-8'); ?>
    </h2>
  </div>
  <span8>
    <table>
      <tr>
        <td>
          <div class="span3">
            <div class="admin-menu-container span3">
              <div class="admin-menu-title">
                <?php echo htmlspecialchars(t("Gates"),ENT_QUOTES,'UTF-8'); ?>
              </div>
              <section>
                <span class="title">
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('gateSets/index')))), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars(Yii::t("app", "Gate Sets"),ENT_QUOTES,'UTF-8'); ?>
                  </a>
                </span>
              </section>
              <?php if($user->checkAccess('manage_gates'))   { ?>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('gateGroup/index')))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(Yii::t("app", "Gate Groups"),ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </span>
                </section>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('gate/index')))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(Yii::t("app", "Gates"),ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </span>
                </section>
              <?php } else                               { ?>
                <section>
                  <span class="title">
                    <?php echo htmlspecialchars(Yii::t("app", "No  availabe action"),ENT_QUOTES,'UTF-8'); ?>
                  </span>
                </section>
              <?php } ?>
            </div>
          </div>
        </td>
        <td>
          <div class="span3">
            <div class="admin-menu-container span3">
              <div class="admin-menu-title">
                <?php echo htmlspecialchars(t("Users"),ENT_QUOTES,'UTF-8'); ?>
              </div>
              <?php if($user->checkAccess('manage_auth')) { ?>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('auth')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Assignments'),ENT_QUOTES,'UTF-8'); ?></a>
                  </span>
                </section>
              <?php } ?>
              <?php if($user->checkAccess('manage_users')) { ?>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('user')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Manage users'),ENT_QUOTES,'UTF-8'); ?></a>
                  </span>
                </section>
              <?php } ?>
              <?php if(!$user->checkAccess('manage_users') && !$user->checkAccess('manage_auth'))                               { ?>
                <section>
                  <span class="title">
                    <?php echo htmlspecialchars(Yii::t("app", "No  availabe action"),ENT_QUOTES,'UTF-8'); ?>
                  </span>
                </section>
              <?php } ?>
            </div>
          </div>
        </td>
        <td>
          <div class="span3">
            <div class="admin-menu-container span3">
              <div class="admin-menu-title">
                <?php echo htmlspecialchars(t("Time Schedule"),ENT_QUOTES,'UTF-8'); ?>
              </div>
              <?php if($user->checkAccess('manage_special_day')) { ?>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('specialDay')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Manage special days'),ENT_QUOTES,'UTF-8'); ?></a>
                  </span>
                </section>
              <?php } ?>
              <?php if($user->checkAccess('manage_time_schedule')) { ?>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('timeSchedule')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Manage time schedule')                    ,ENT_QUOTES,'UTF-8'); ?></a>
                  </span>
                </section>
              <?php } ?>
              <?php if(!$user->checkAccess('manage_special_day') && !$user->checkAccess('manage_time_schedule'))                               { ?>
                <section>
                  <span class="title">
                    <?php echo htmlspecialchars(Yii::t("app", "No  availabe action"),ENT_QUOTES,'UTF-8'); ?>
                  </span>
                </section>
              <?php } ?>
            </div>
          </div>
        </td>
      </tr>
      <tr>
        <td>
          <div class="span3">
            <div class="admin-menu-container span3">
              <div class="admin-menu-title">
                <?php echo htmlspecialchars(t("Tasks"),ENT_QUOTES,'UTF-8'); ?>
              </div>
              <?php if($user->checkAccess('manage_tasks'))   { ?>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('runSchedule/admin')))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t('Manage Run Schedules'),ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </span>
                </section>
              <?php } else                               { ?>
                <section>
                  <span class="title">
                    <?php echo htmlspecialchars(Yii::t("app", "No  availabe action"),ENT_QUOTES,'UTF-8'); ?>
                  </span>
                </section>
              <?php } ?>
            </div>
          </div>
        </td>
        <td>
          <div class="span3">
            <div class="admin-menu-container span3">
              <div class="admin-menu-title">
                <?php echo htmlspecialchars(t("Behaviors"),ENT_QUOTES,'UTF-8'); ?>
              </div>
              <?php $visibleItemsCount = 0; ?>
              <?php if($user->checkAccess('gate_behavior_management')) { ?>
                <?php $visibleItemsCount++; ?>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('gateBehavior/admin')))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t('Manage Gate Behaviors'),ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </span>
                </section>
              <?php } ?>
              <?php if($user->checkAccess('behavior_management')) { ?>
                <?php $visibleItemsCount++; ?>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('behavior/admin')))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t('Manage Behaviors'),ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </span>
                </section>
              <?php } ?>
              <?php if($visibleItemsCount <= 0) { ?>
                <section>
                  <span class="title">
                    <?php echo htmlspecialchars(Yii::t("app", "No  availabe action"),ENT_QUOTES,'UTF-8'); ?>
                  </span>
                </section>
              <?php } ?>
            </div>
          </div>
        </td>
        <td>
          <?php if(paramdeep('adminPanel','showMeanSpeed')) { ?>
            <div class="span3">
              <div class="admin-menu-container span3">
                <div class="admin-menu-title">
                  <?php echo htmlspecialchars(t("Mean speed"),ENT_QUOTES,'UTF-8'); ?>
                </div>
                <?php if($user->checkAccess('section_management'))   { ?>
                  <section>
                    <span class="title">
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('section/admin')))), 'html5', 'UTF-8'); ?>>
                        <?php echo htmlspecialchars(t('Manage Sections'),ENT_QUOTES,'UTF-8'); ?>
                      </a>
                    </span>
                  </section>
                  <section>
                    <span class="title">
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('crossingTime/admin')))), 'html5', 'UTF-8'); ?>>
                        <?php echo htmlspecialchars(t('Manage Crossing Times'),ENT_QUOTES,'UTF-8'); ?>
                      </a>
                    </span>
                  </section>
                <?php } else                               { ?>
                  <section>
                    <span class="title">
                      <?php echo htmlspecialchars(Yii::t("app", "No  availabe action"),ENT_QUOTES,'UTF-8'); ?>
                    </span>
                  </section>
                <?php } ?>
              </div>
            </div>
          <?php } ?>
        </td>
      </tr>
      <tr>
        <td>
          <div class="span3">
            <div class="admin-menu-container span3">
              <div class="admin-menu-title">
                <?php echo htmlspecialchars(t("Violations"),ENT_QUOTES,'UTF-8'); ?>
              </div>
              <?php $visibleItemsCount = 0; ?>
              <?php if($user->checkAccess('violation_document_manage')) { ?>
                <?php $visibleItemsCount++; ?>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('ViolationDocument/admin')))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t('Violations documents'),ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </span>
                </section>
              <?php } ?>
              <?php if($user->checkAccess('violations_queued')) { ?>
                <?php $visibleItemsCount++; ?>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('event/queued')))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t('View queued violations'),ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </span>
                </section>
              <?php } ?>
              <?php if($visibleItemsCount == 0) { ?>
                <section>
                  <span class="title">
                    <?php echo htmlspecialchars(Yii::t("app", "No  availabe action"),ENT_QUOTES,'UTF-8'); ?>
                  </span>
                </section>
              <?php } ?>
            </div>
          </div>
        </td>
        <?php if(paramdeep('adminPanel','showPlateAuthProfile')) { ?>
          <td>
            <div class="span3">
              <div class="admin-menu-container span3">
                <div class="admin-menu-title">
                  <?php echo htmlspecialchars(t("Plate authorizations"),ENT_QUOTES,'UTF-8'); ?>
                </div>
                <?php $visibleItemsCount = 0; ?>
                <?php if($user->checkAccess('plateauthinsertprofile_management')) { ?>
                  <?php $visibleItemsCount++; ?>
                  <section>
                    <span class="title">
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('PlateAuthInsertProfile/admin')))), 'html5', 'UTF-8'); ?>>
                        <?php echo htmlspecialchars(t('Manage Plate Auth Insert Profiles'),ENT_QUOTES,'UTF-8'); ?>
                      </a>
                    </span>
                  </section>
                <?php } ?>
                <?php if($user->checkAccess('plate_auth_tabula_rasa')) { ?>
                  <?php $visibleItemsCount++; ?>
                  <section>
                    <span class="title">
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('PlateAuthorization/tabularasa')))), 'html5', 'UTF-8'); ?>>
                        <?php echo htmlspecialchars(t('Tabula Rasa'),ENT_QUOTES,'UTF-8'); ?>
                      </a>
                    </span>
                  </section>
                <?php } ?>
                <?php if($visibleItemsCount == 0) { ?>
                  <section>
                    <span class="title">
                      <?php echo htmlspecialchars(Yii::t("app", "No  availabe action"),ENT_QUOTES,'UTF-8'); ?>
                    </span>
                  </section>
                <?php } ?>
              </div>
            </div>
          </td>
        <?php } ?>
        <td>
          <div class="span3">
            <div class="admin-menu-container span3">
              <div class="admin-menu-title">
                <?php echo htmlspecialchars(t("Violations"),ENT_QUOTES,'UTF-8'); ?>
              </div>
              <?php $visibleItemsCount = 0; ?>
              <?php if($user->checkAccess('violation_code_manage')) { ?>
                <?php $visibleItemsCount++; ?>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('violationcode/admin')))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t('Violation codes'),ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </span>
                </section>
              <?php } ?>
              <?php if($user->checkAccess('custom_plate_type_manage')) { ?>
                <?php $visibleItemsCount++; ?>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('CustomPlateType/admin')))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t('Custom Plate Type'),ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </span>
                </section>
              <?php } ?>
              <?php if($user->checkAccess('custom_property_type_manage')) { ?>
                <?php $visibleItemsCount++; ?>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('CustomPropertyType/admin')))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t('Custom Property Type'),ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </span>
                </section>
              <?php } ?>
              <?php if($visibleItemsCount == 0) { ?>
                <section>
                  <span class="title">
                    <?php echo htmlspecialchars(Yii::t("app", "No  availabe action"),ENT_QUOTES,'UTF-8'); ?>
                  </span>
                </section>
              <?php } ?>
            </div>
          </div>
        </td>
      </tr>
      <tr>
        <td>
          <div class="span3">
            <div class="admin-menu-container span3">
              <div class="admin-menu-title">
                <?php echo htmlspecialchars(t("System"),ENT_QUOTES,'UTF-8'); ?>
              </div>
              <?php if($user->checkAccess('system_management'))   { ?>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('system/config')))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t('View sytem configuration'),ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </span>
                </section>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('system/configExport')))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t('Export sytem configuration'),ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </span>
                </section>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('system/configImport')))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t('Import sytem configuration')                ,ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </span>
                </section>
                <section>
                  <span class="title">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('system/configRestore')))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t('Restore sytem configuration'),ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </span>
                </section>
              <?php } else                               { ?>
                <section>
                  <span class="title">
                    <?php echo htmlspecialchars(Yii::t("app", "No  availabe action"),ENT_QUOTES,'UTF-8'); ?>
                  </span>
                </section>
              <?php } ?>
            </div>
          </div>
        </td>
      </tr>
      <?php if((paramdeep('adminPanel','showDebug') && DebugController::canDebug()) || DebugController::isInDebugMode() || YII_DEBUG)   { ?>
        <tr>
          <td>
            <div class="span3">
              <div class="admin-menu-container span3">
                <div class="admin-menu-title">
                  <div class="icon-bug"></div>
                  <?php echo htmlspecialchars(t("Debug"),ENT_QUOTES,'UTF-8'); ?>
                </div>
                <?php if(!DebugController::isInDebugMode()) { ?>
                  <section>
                    <span class="title">
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/EnableDebug')))), 'html5', 'UTF-8'); ?>>
                        <div class="icon-signin"></div>
                        <?php echo htmlspecialchars(t('Enter Debug Mode'),ENT_QUOTES,'UTF-8'); ?>
                      </a>
                    </span>
                  </section>
                <?php } else { ?>
                  <section>
                    <span class="title">
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/index')))), 'html5', 'UTF-8'); ?>>
                        <div class="icon-bug"></div>
                        <?php echo htmlspecialchars(t("Debug"),ENT_QUOTES,'UTF-8'); ?>
                      </a>
                    </span>
                  </section>
                  <section>
                    <span class="title">
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('debug/DisableDebug')))), 'html5', 'UTF-8'); ?>>
                        <div class="icon-signout"></div>
                        <?php echo htmlspecialchars(t('Leave Debug Mode'),ENT_QUOTES,'UTF-8'); ?>
                      </a>
                    </span>
                  </section>
                <?php } ?>
              </div>
            </div>
          </td>
        </tr>
      <?php } ?>
    </table>
  </span8>
</div>
