<?php $types = paramdeep('plateAuthorizations','types') ; ?>
<h3>
  <?php echo htmlspecialchars(t('Plate authorization'),ENT_QUOTES,'UTF-8'); ?>
  <?php echo htmlspecialchars('#',ENT_QUOTES,'UTF-8'); ?>
  <?php echo htmlspecialchars($plateAuthorization->ID  ,ENT_QUOTES,'UTF-8'); ?>
</h3>
<table class="table table-striped table-condensed">
  <thead>
    <tr>
      <th></th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->getAttributeLabel('Descrizione'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->Descrizione,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->getAttributeLabel('type'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars(array_key_exists($plateAuthorization->type, $types) ? $types[$plateAuthorization->type] : $plateAuthorization->type,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->getAttributeLabel('GateID'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo SystemInfoHelper::getPlateAuthGateCoolName($plateAuthorization->GateID,$plateAuthorization->GateID_type); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->getAttributeLabel('TimeID'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo SystemInfoHelper::getTimeScheduleCoolName($plateAuthorization->TimeID); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->getAttributeLabel('action'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->action,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->getAttributeLabel('Note'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->Note,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('List'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->plate_list->name ,ENT_QUOTES,'UTF-8'); ?>
        <?php echo htmlspecialchars(' - '   ,ENT_QUOTES,'UTF-8'); ?>
        <?php echo htmlspecialchars($plateAuthorization->plate_list->title,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->getAttributeLabel('epoch'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->epoch,ENT_QUOTES,'UTF-8'); ?>
        <?php echo htmlspecialchars(' (',ENT_QUOTES,'UTF-8'); ?>
        <?php if(Yii::app()->user->checkAccess('user_view') && $plateAuthorization->insertid>0) { ?>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('user/'.$plateAuthorization->insertid)))), 'html5', 'UTF-8'); ?>>
            <i>
              <?php echo htmlspecialchars($plateAuthorization->getSubmitter(),ENT_QUOTES,'UTF-8'); ?>
            </i>
          </a>
        <?php } else { ?>
          <i>
            <?php echo htmlspecialchars($plateAuthorization->getSubmitter(),ENT_QUOTES,'UTF-8'); ?>
          </i>
        <?php } ?>
        <?php echo htmlspecialchars(')',ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
  </tbody>
</table>
