<?php

/**
 * This is the model class for table "system_status".
 *
 * The followings are the available columns in table 'system_status':
 * @property string $id
 * @property string $name
 * @property string $description
 * @property string $status
 * @property string $last_update
 * @property string $update_timeout
 * @property string $last_error_log
 * @property integer $system_runnning
 * @property string $epoch
 */
class SystemStatus extends ActiveRecord
{
	const STATUS_ALIVE								= 'alive';
	const STATUS_DEAD									= 'dead';
	const STATUS_UNDEF								= 'undef';
	const STATUS_TIMEOUT_EXPIRED			= 'timeout_expired';
	
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SystemStatus the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'system_status';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('system_runnning', 'numerical', 'integerOnly'=>true),
			array('name, description, status, last_error_log', 'length', 'max'=>250),
			array('update_timeout', 'length', 'max'=>20),
			array('last_update, epoch', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, name, description, status, last_update, update_timeout, last_error_log, system_runnning, epoch', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function myAttributeLabels()
	{
		return array(
			'id' => 'ID',
			'name' => 'Name',
			'description' => 'Description',
			'status' => 'Status',
			'last_update' => 'Last Update',
			'update_timeout' => 'Update Timeout',
			'last_error_log' => 'Last Error Log',
			'system_runnning' => 'System Runnning',
			'epoch' => 'Epoch',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('last_update',$this->last_update,true);
		$criteria->compare('update_timeout',$this->update_timeout,true);
		$criteria->compare('last_error_log',$this->last_error_log,true);
		$criteria->compare('system_runnning',$this->system_runnning);
		$criteria->compare('epoch',$this->epoch,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}