<?php

class Report extends CComponent
{

  /**
   *
   * @var EventsRepository
   */
  private $repository;

  /**
   *
   * @var WorkPeriod
   */
  private $session;

  /**
   *
   * @param WorkPeriod $session          
   * @param boolean $approvedOnly
   *          default true
   */
  public function __construct(WorkPeriod $session, $approvedOnly = true)
  {
    $eventsOrderBy = paramdeep ( 'report', 'events', 'order' );
    $removeDefaultScope = paramdeep ( 'report', 'events', 'removeDefaultScope' );
    $this->session = $session;
    
    /** @var Event $searchObj */
    $searchObj = Event::model ();
    
    $searchObj->byValidator ( $session->user );
    $searchObj->validatedBetween ( $session->login_at, $session->last_action_at );
    
    if ($removeDefaultScope)
      $searchObj->resetScope ();
    
    if (! isEmptyOrWhitespace ( $eventsOrderBy ))
      $searchObj->setOrderBy ( $eventsOrderBy );
    
    if ($approvedOnly)
    {
      $searchObj->approved ();
    }
    else
    {
      $searchObj->approvedOrInvalid ();
    }
    
    $events = $searchObj->findAll ();
    
    $this->repository = new EventsRepository ( $events );
  }

  /**
   *
   * @param WorkPeriod $session          
   * @return integer
   */
  static public function numOfEventsToBeTagged(WorkPeriod $session)
  {
    $numOfEvents = Event::model ()->approvedOrInvalid ()
      ->notClosedYet ()
      ->byValidator ( $session->user )
      ->validatedBetween ( $session->login_at, $session->last_action_at )
      ->howMany ();
    
    return $numOfEvents;
  }

  /**
   *
   * @param unknown $session          
   * @return integer
   */
  static public function numOfEventsInvalid(WorkPeriod $session)
  {
    $numOfEvents = Event::model ()->invalid ()
      ->byValidator ( $session->user )
      ->validatedBetween ( $session->login_at, $session->last_action_at )
      ->howMany ();
    
    return $numOfEvents;
  }

  /**
   *
   * @param unknown $session          
   * @return integer
   */
  static public function numOfEventsApproved(WorkPeriod $session)
  {
    $numOfEvents = Event::model ()->approved ()
      ->byValidator ( $session->user )
      ->validatedBetween ( $session->login_at, $session->last_action_at )
      ->howMany ();
    
    return $numOfEvents;
  }

  /**
   *
   * @return EventsRepository
   */
  public function getRepository()
  {
    return $this->repository;
  }
}
