<?php

class VehicleTypes
{

  static public function localized()
  {
    $types = array();
    $types['Person'] = Yii::t('app', 'Person');
    $types['Vehicle'] = Yii::t('app', 'Vehicle');
    $types['Truck'] = Yii::t('app', 'Truck');
    $types['Articulated lorry'] = Yii::t('app', 'Articulated lorry');
    $types['Bus'] = Yii::t('app', 'Bus');
    $types['Motorcycle'] = Yii::t('app', 'Motorcycle');
    $types['Motor-scooter'] = Yii::t('app', 'Motor-scooter');
  
    asort($types);
  
    $types['Undefined'] = Yii::t('app', 'Undefined');
  
    return $types;
  }
  
  static public function getClassesForSelection()
  {
    $types = VehicleTypes::localized();
     
    $res = array();
    foreach ($types as $key => $value)
    		$res[] = array('key' => $key, 'value' => $value);
     
    return $res;
  }

  static public function localizedMotored()
  {
    $types = array();
    $types['Vehicle'] = Yii::t('app', 'Vehicle');
    $types['Truck'] = Yii::t('app', 'Truck');
    $types['Articulated lorry'] = Yii::t('app', 'Articulated lorry');
    $types['Bus'] = Yii::t('app', 'Bus');
    $types['Motorcycle'] = Yii::t('app', 'Motorcycle');
    $types['Motor-scooter'] = Yii::t('app', 'Motor-scooter');
  
    asort($types);
  
    return $types;
  }
  
  static public function getClassName($class)
  {
  	$types = VehicleTypes::localized();
  	
  	if(isset($types[$class]))
  		return $types[$class];
  	
  	return $class;
  }
  
  
  
  static public function getFromDeviceClass($class)
  {
		$class = 	strtolower($class);
			
		if($class == "person" || $class == "persona")
			return 'Person';
		if($class == "vehicle" || $class == "veicolo")
			return 'Vehicle';
		else if($class == "truck" || $class == "mezzo_pesante")
			return 'Truck';
		else if($class == "motorbike" || $class == "motorcycle" || $class == "motociclo")
			return 'Motorcycle';
		else if($class == "bus")
			return 'Bus';
		
		return 'Vehicle';
  }
  
  private static function imageUrl($className)
  {
  	$className = strtolower($className);
  	
  	return Yii::app()->baseUrl."/images/vehicle-classes/{$className}.png";
  }
  
  public static function tagForVehicleClass($className)
  {
  	if(is_null($className))
  		return null;
  	 
  	$imageUrl = self::imageUrl($className);
  
  	return CHtml::image($imageUrl, $className, array('class' => 'vehicle-class-icon-small'));
  }
  
}
