<?php

class ReportController extends Controller
{

  public $layout = '//layouts/print';

  public function actionCreate()
  {
    if (! isset ( $_REQUEST ['workPeriodID'] ))
      throw new CHttpException ( 400, Yii::app ( 't', 'workPeriodID is required.' ) );
    
    $workPeriodID = ( int ) $_REQUEST ['workPeriodID'];
    
    $this->showReport ( $workPeriodID, false );
  }

  public function actionPreview()
  {
    if (! isset ( $_REQUEST ['workPeriodID'] ))
      throw new CHttpException ( 400, Yii::app ( 't', 'workPeriodID is required.' ) );
    
    $workPeriodID = ( int ) $_REQUEST ['workPeriodID'];
    
    $this->showReport ( $workPeriodID, true );
  }

  /**
   *
   * @param integer $workPeriodID          
   * @param boolean $preview          
   */
  protected function showReport($workPeriodID, $preview)
  {
    $period = $this->loadWorkPeriod ( $workPeriodID );
    
    $report = new Report ( $period, false ); // approved and invalid
    
    if (! $preview)
    {
      $events = EventTagger::tag ( $report->repository->all );
    }
    else
    {
      $events = array_convert ( $report->repository->all, function (Event $e)
      {
        $e->ext_code = $e->validation_result == 'approved' ? 'DEMO' : ExtCode::NULL_EXT_CODE;
        return $e;
      } );
    }
    
    if ($period->report_generation_date == NULL)
    {
      $converterEventToId = function (Event $e)
      {
        return $e->ID;
      };
      
      $reportApproved = new Report ( $period, true ); // approved only
      $eventsApproved = $reportApproved->repository->all;
      if (! $preview)
      {
        $period->report_generation_date = new DateTime ();
        $period->events_count = count ( $eventsApproved );
        $period->events_ids = implode ( ",", array_convert ( $eventsApproved, $converterEventToId ) );
        $period->save ();
      }
    }
    
    $eventsByGateGroup = GroupEventsByGateGroup::run ( $events );
    
    if (! $preview)
      if (! $period->closed)
        Yii::app ()->user->logout ();
    
    $this->render ( 'create', get_defined_vars () );
  }

  public function actionConfirm($workPeriodID)
  {
    // ensure work period really exists
    $workPeriod = $this->loadWorkPeriod ( $workPeriodID );
    
    $this->renderPartial ( '_confirm', array (
        'workPeriodID' => $workPeriod->id,
        'workPeriodClosed' => $workPeriod->closed 
    ) );
  }

  public function actionViewSummary($workPeriodID)
  {
    $period = $this->loadWorkPeriod ( $workPeriodID );
    $report = new Report ( $period );
    $this->renderPartial ( '/workPeriod/_summary', array (
        'workPeriodID' => $workPeriodID,
        'repository' => $report->repository 
    ) );
  }

  /**
   *
   * @param integer $id          
   * @throws CHttpException
   * @return WorkPeriod
   */
  public function loadWorkPeriod($id)
  {
    $period = WorkPeriod::model ()->findByPk ( $id );
    if ($period === null)
      throw new CHttpException ( 404, Yii::t ( 'app', 'The requested page does not exist.' ) );
    return $period;
  }
}
