<?php
return array (
    
    'yiiPath' => dirname ( __FILE__ ) . '/../../../yii-1.1.13/framework/yii.php',
    'yiicPath' => dirname ( __FILE__ ) . '/../../../yii-1.1.13/framework/yiic.php',
    'yiitPath' => dirname ( __FILE__ ) . '/../../../yii-1.1.13/framework/yiit.php',
    
    'yiiDebug' => true,
    'yiiTraceLevel' => 0,
    
    // Static function Yii::setPathOfAlias()
    'yiiSetPathOfAlias' => array (
        'bootstrap' => dirname ( __FILE__ ) . '/../extensions/bootstrap',
        'protected' => dirname ( __FILE__ ) . '/../' 
    ),
    
    'configWeb' => array (
        'basePath' => dirname ( __FILE__ ) . '/..',
        'name' => 'Event Server',
        'sourceLanguage' => 'en',
        'language' => 'it',
        'defaultController' => 'dashboard',
        
        'preload' => array (
            'log' 
        ),
        
        // autoloading model and component classes
        'import' => array (
            'application.enums.*',
            'application.models.*',
            'application.controllers.*',
            'application.presenters.*',
            'application.services.*',
            'application.repositories.*',
            'application.queries.*',
            'application.components.*',
            'application.helpers.*',
            'application.vendor.*',
            'ext.PHPExcelLib.*',
            'ext.JsTrans.*',
            'ext.ECSVExport.*',
            'ext.bootstrap.widgets*',
            'ext.efeed.*',
            'ext.dynamictabularform.*' 
        ),
        
        'modules' => array (
            'auth' => array (
                'strictMode' => true, // when enabled authorization items cannot be assigned children of the same type.
                'userClass' => 'User', // the name of the user model class.
                'userIdColumn' => 'id', // the name of the user id column.
                'userNameColumn' => 'username', // the name of the user name column.
                'appLayout' => 'application.views.layouts.main', // the layout used by the module.
                'viewDir' => null 
            ) 
        ), // the path to view files to use with this module.
        
        'components' => array (
            'user' => array (
                'class' => 'auth.components.AuthWebUser',
                'allowAutoLogin' => false,
                'autoUpdateFlash' => false,
                'loginUrl' => array (
                    'session/login' 
                ),
                'loginRequiredAjaxResponse' => 'Error, login required' 
            ),
            'viewRenderer' => array (
                'class' => 'ext.yii-mthaml.CMtHamlViewRenderer' 
            ),
            'bootstrap' => array (
                'class' => 'bootstrap.components.Bootstrap' 
            ),
            'urlManager' => array (
                'urlFormat' => 'path',
                'showScriptName' => false,
                'rules' => array (
                    '<controller:\w+>/<id:\d+>' => '<controller>/view',
                    '<controller:\w+>/<action:\w+>/<id:\d+>' => '<controller>/<action>',
                    '<controller:\w+>/<action:\w+>' => '<controller>/<action>' 
                ) 
            ),
            'authManager' => array (
                'class' => 'CDbAuthManager',
                'connectionID' => 'db',
                'itemTable' => 'authitem',
                'itemChildTable' => 'authitemchild',
                'assignmentTable' => 'authassignment',
                'behaviors' => array (
                    'auth' => array (
                        'class' => 'auth.components.AuthBehavior',
                        'admins' => array () 
                    ) 
                ) 
            ), // users with full access
            
            'errorHandler' => array (
                'errorAction' => 'site/error' 
            ),
            'mutex' => array (
                'class' => 'ext.EMutex' 
            ),
            'log' => array (
                'class' => 'CLogRouter',
                'routes' => array (
                    "application" => array (
                        'class' => 'CFileLogRoute',
                        'levels' => 'error, warning, profile' 
                    ),
                    "info" => array (
                        'class' => 'CFileLogRoute',
                        'logFile' => 'info.log',
                        'levels' => 'info' 
                    ) 
                ) 
            ),
            'request' => array (
                'enableCookieValidation' => true,
                'class' => 'HttpRequest' 
            ),
            'session' => array (
                'class' => 'CDbHttpSession',
                'connectionID' => 'db',
                'autoCreateSessionTable' => false,
                'sessionTableName' => 'yii_session',
                'timeout' => (60 * 60 * 8), // 8 ore
                'cookieMode' => 'only' 
            ),
            'currentWorkPeriod' => array (
                'class' => 'CurrentWorkPeriod' 
            ),
            'currentSession' => array (
                'class' => 'CurrentSession' 
            ),
            
            'curl' => array (
                'class' => 'ext.Curl' 
            ),
            // 'options' => array(/.. additional curl options ../)
            
            'messages' => array (
                'class' => 'P3PhpMessageSource',
                'mappings' => array (
                    'de_de' => 'de',
                    'de_at' => 'de',
                    'de_ch' => 'de',
                    'fr_ch' => 'fr',
                    'it_ch' => 'it' 
                ) 
            ) 
        ),
        'params' => array (
            'db' => array (
                'cache' => array (
                    'enabled' => false,
                    'types' => array (
                        'Bookmark',
                        'PlateCountry',
                        'Service',
                        'Gate',
                        'Ztl',
                        'PlateList',
                        'PlateAuthInsertProfile',
                        'TimeSchedule',
                        'GateSet',
                        'GateGroup',
                        'MediaAttachment',
                        'Event' 
                    ) 
                ) 
            ),
            'translator' => array (
                'enabled' => true 
            ),
            'payslip' => array (
                'showButton' => false 
            ),
            'report' => array (
                'showPreviewButton' => true,
                'events' => array (
                    'order' => null,
                    'removeDefaultScope' => false 
                ) 
            ),
            'section' => array (
                'classLimits' => 'default' 
            ), // false=disabled, 'default'=default classes, array('class1','class2',...)=specified classes
            'video' => array (
                'enabledRefreshDivButton' => false 
            ),
            'service' => array (
                'paginationSize' => 20 
            ),
            'security' => array (
                'user_tracking' => array (
                    'enabled' => true,
                    'pagination' => 50,
                    'exclude_tables' => array (
                        'user_tracking_table',
                        'work_periods' 
                    ),
                    'data_tracked_table' => array () 
                ),
                'ipFilter' => array (
                    'enabled' => false,
                    'allow' => array (), // empty = all
                    'deny' => array (), // empty = none/*=all
                    'allowOverDeny' => true 
                ), // false=deny overrides allow - true=allow overrides deny
                'logFile' => dirname ( __FILE__ ) . '/../runtime/security.log',
                'logContext' => array (
                    'app',
                    'login',
                    '401' 
                ), // VALORI: app login 401 actions
                'logStack' => true,
                'logActions' => array (
                    'bypass' => array (
                        'alert/summary',
                        'gatesstatus/viewviolationsstable',
                        'gatesstatus/viewgatelist',
                        'stats/statusbox',
                        'gatesstatus/viewalertstable',
                        'system/statusbox',
                        'event/statusbox',
                        'dashboard/viewservices' 
                    ), // LOWERCASE - le azioni da non loggare (ovvero quelle di aggiornamento dati)
                    'specific' => array (), // LOWERCASE - se contiene elementi 'logActionsBypass' viene ignorato e vengono loggate SOLO le azioni specificate
                    'requestData' => array (
                        'search/index',
                        'event/admin',
                        'vehicletrace/admin',
                        'alert/search',
                        'plateauthorization/index',
                        'plateauthorization/whiteliststatus',
                        'plateList/*',
                        'plateauthorization/newblacklist',
                        'plateauthorization/newwhitelist',
                        'plateauthorization/whitelistwizard',
                        'plateauthorization/whitelistwizarddelete',
                        'vehicleowner/*',
                        'vehicle/*',
                        'plateauthorization/revoke',
                        'plateauthorization/renew',
                        'user/*',
                        'fastassign/*',
                        'assignment/*',
                        'role/*',
                        'operation/*',
                        'task/*',
                        'configuration/*' 
                    ) 
                ) 
            ), // LOWERCASE - dice quando vanno loggati i dati delle richieste
            
            'photoBaseLocationByUrl' => false,
            'photoBaseUrl' => '/kria-photos',
            'photoBasePath' => 'D:\mysql\data',
            'support' => array (
                'visible_to_guest' => true,
                'visible_to_user' => true,
                'email' => array (
                    'general' => 'info@kria.biz',
                    'commercial' => 'sales@kria.biz',
                    'support' => 'support@kria.biz',
                    'admin' => 'admin@kria.biz' 
                ) 
            ),
            'plateList' => array (),
            'plateAuthorizations' => array (
                'scheduler' => array (
                    'hotelMode' => true,
                    'softMode' => true,
                    'additionalWeeksBeforeMonth' => 2,
                    'additionalWeeksAfterMonth' => 2 
                ),
                'expirationTimeoutWarning' => '7 days',
                'expirationTimeoutCritical' => '12 hours',
                'aboutToExpireTimeout' => '1 month',
                'tabularasa' => array (
                    'password' => 'ab173b7560cf37726aee0b47440ea1af',
                    'allowed' => true 
                ),
                'viewGoToWizardLink' => true,
                'print' => array (
                    'link' => array (
                        'direct' => false, // default: false, se diretta newPage e popup vengono ignorate
                        'newPage' => true, // default: true, se false popup viene ignorato
                        'popup' => true 
                    ) 
                ), // default: true, se true apre un popup altrimenti una nuova finestra del browser altrimenti
                
                'customValidityPeriods' => array (),
                'vehicleSources' => array (), // se vuota, campo libero
                'printLayout' => '',
                'validityPeriodType' => array (
                    'Fisso' => 'Fisso' 
                ),
                'types' => array (),
                'default' => array (
                    'name' => '',
                    'surname' => '',
                    'gate' => '-1',
                    'time' => '-1',
                    'validityPeriodDescription' => '',
                    'validityPeriodType' => 'Fisso',
                    'plateAuthDescription' => '',
                    'plateAuthType' => '-',
                    'plateAuthAction' => '',
                    'plateAuthNote' => '',
                    'vehicleSource' => '' 
                ),
                'rapidInsert' => array (
                    // veicolo
                    'hideVehicleModel' => false,
                    'hideVehicleType' => false,
                    // permit
                    'hideAuthType' => false,
                    // contatto
                    'hideEmail' => false,
                    'hidePhone' => false,
                    'hideAddress' => false,
                    'hideCity' => false,
                    // altre info
                    'hideSource' => false,
                    'hideAction' => false,
                    'hideNote' => false 
                ),
                'autocomplete' => array (
                    'note' => array (
                        'enabled' => true,
                        'table' => true,
                        'custom' => array () 
                    ) 
                ) 
            ),
            'datetimeselect_format' => array (
                'it' => array (
                    'view' => 'dd/MM/yyyy hh:mm',
                    'php' => 'd/m/Y H:i' 
                ),
                'it_ch' => array (
                    'view' => 'dd/MM/yyyy hh:mm',
                    'php' => 'd/m/Y H:i' 
                ),
                'en' => array (
                    'view' => 'MM/dd/yyyy hh:mm',
                    'php' => 'm/d/Y H:i' 
                ) 
            ),
            'dateselect_format' => array (
                'it' => array (
                    'view' => 'dd/MM/yyyy',
                    'php' => 'd/m/Y' 
                ),
                'it_ch' => array (
                    'view' => 'dd/MM/yyyy',
                    'php' => 'd/m/Y' 
                ),
                'en' => array (
                    'view' => 'MM/dd/yyyy',
                    'php' => 'm/d/Y' 
                ) 
            ),
            'dayoftheyearselect_format' => array (
                'it' => array (
                    'view' => 'dd/MM',
                    'php' => 'd/m' 
                ),
                'it_ch' => array (
                    'view' => 'dd/MM',
                    'php' => 'd/m' 
                ),
                'en' => array (
                    'view' => 'MM/dd',
                    'php' => 'm/d' 
                ) 
            ),
            'timeselect_format' => array (
                'it' => array (
                    'view' => 'hh:mm',
                    'php' => 'H:i' 
                ),
                'it_ch' => array (
                    'view' => 'dd/MM',
                    'php' => 'd/m' 
                ),
                'en' => array (
                    'view' => 'hh:mm',
                    'php' => 'H:i' 
                ) 
            ),
            'pdfRepositoryBaseFolder' => 'D:\PDF\\',
        	'gate_status_refresh_time' =>   60000,
        	'system_status_refresh_time' => 60000,

        		
            // To create self-signed signature: openssl req -x509 -nodes -days 365000 -newkey rsa:1024 -keyout tcpdf.crt -out tcpdf.crt
            // file:// DEVE ESSERCI!
            'exportPdfCertificate' => 'file://' . dirname ( __FILE__ ) . '/cert/kria.crt', // file://C:\temp\tmpcrt\tcpdf.crt',
            'exportPdfCertificatePassword' => kria_load_secret ( 'exportPdfCertificatePassword' ),
            'passwordExpirationNotification' => 7,
            'publicPages' => array (
                'system/setup',
                'system/repair',
                'site/error',
                'alert/rss',
                'session/login',
                'session/refreshpassword',
                'webImageAccess/Index',
                'webImageAccess/EventInfo',
                'webImageAccess/EventImage',
                'api/*',
                'ws/*',
                'support/*',
                'maintenanceMode/*' 
            ),
            'webImageAccess' => array (
                'BaseFolder' => 'D:\ES_WEB_SERVICE\\',
                'defaultTopMargin' => 500,
                'defaultBottomMargin' => 300,
                'defaultLeftMargin' => 400,
                'defaultRightMargin' => 400,
                'defaultBottomBandSize' => 48 
            ),
            'logos' => array (
                'login' => 'logo-kria-high.gif' 
            ),
            'logosStyles' => array (
                'login' => '' 
            ),
            'appTitles' => array (
                'main_title' => null,
                'main_title_is_html' => false,
                'sub_title' => 'Sistema video di rilevamento e identificazione dei veicoli',
                'sub_title_is_html' => false 
            ),
            'spotSpeedViolation' => array (
                'fixedTolerance' => 5,
                'percentageTolerance' => 0.05,
                'toleranceTable' => array () 
            ),
            // array('minSpeed'=> 0, 'maxSpeed'=> 100, 'tolerance' => 5),
            // array('minSpeed'=> 100, 'maxSpeed'=> 150, 'tolerance' => 6),
            // array('minSpeed'=> 150, 'maxSpeed'=> 500, 'tolerance' => 7),
            
            'features' => array (
                'alertManagement' => true,
                'eventReporting' => false 
            ),
            'menuTitles' => array (
                'dashboard' => null,
                'gateStatus' => null,
                'map' => null,
                'live' => null,
                'services' => null,
                'ztl' => null,
                'admin' => null,
                'search' => null,
                'stats' => null,
                'diagnostic' => null,
                'alerts' => null,
                'plateAuthorizationWL' => null,
                'plateAuthorizationBL' => null,
                'plateAuthorizationBWL' => null 
            ),
            'statusBar' => array (
                'showPoweredBy' => true,
                'showAlerts' => true,
                'showSystemStatus' => true,
                'showTransits' => true,
                'showViolations' => true,
                'showClock' => true 
            ),
            'footer' => array (
                'showPoweredBy' => true 
            ),
            'gateStatus' => array (
                'lastViolationMinutes' => 60 * 24 * 60,
                'showViolations' => true,
                'showTransits' => true,
                'showViolationsList' => true,
                'showAlertsList' => true,
                'showZtlStatus' => false,
                'newEvents_TimeField' => 'StartTime',
                'validatedEvents_TimeField' => 'ValidationTime',
                'exportedEvents_TimeField' => 'ext_code_time' 
            ),
            'ztl' => array (
                'active' => true, // se off dovrebbero sparire tutti i riferimenti specifici alla ZTL! controller, link, etc... (permessi e liste esclusi)
                'name' => 'Area pedonale',
                'showZtlOnGateStatus' => true 
            ),
            'modelLabelsOverride' => array (),
            'hideSystemStatus' => array (
                'SCNTT' => true 
            ),
            'adminPanel' => array (
                'showMeanSpeed' => true,
                'showPlateAuthProfile' => false,
                'showDeug' => true 
            ),
            'debug' => array (
                'showViewLink' => false,
                'showMissingMigrations' => false,
                'autoEnable' => false,
                'password' => '7496c4c241310446201ca21feb5e60a7',
                'strictCheck' => true 
            ), // strictCheck: say if a user MUST own directly the 'debug' auth or can be and admin or inherited
            'gateFunctions' => array (
                'ANY' => 'Any' 
            ),
            'configurationEditor' => array (
                'password' => 'ab7f30d27b5c365a07b433e59cf61706' 
            ),
            'map' => array (
                'index' => 'index2', // valori possibili: index index2 ...
                'options' => array (
                    'index' => array (),
                    'index2' => array () 
                ) 
            ),
            'events' => array (
                'deleteEnabled' => true,
                'nationality' => array (
                    'required' => true,
                    'default' => false 
                ) 
            ), // or IT,EN,...
            
            'validation' => array (
                'viewAllViolationDocuments' => true,
                'voidButton' => array (
                    'enabled' => false 
                ),
                'viewOtherViolations' => true,
                'plate' => array (
                    'alphanumeric' => true,
                    'suggestions' => true 
                ),
                'comment' => array (
                    'autocomplete' => array (
                        'enabled' => true,
                        'table' => true,
                        'custom' => array () 
                    ) 
                ),
                'showSaveAndReleaseButton' => true 
            ),
            'media' => array (
                'enableEnhancedMode' => false,
                'plateRectFix' => array (
                    'top' => 10,
                    'left' => 10,
                    'right' => 10,
                    'bottom' => 10 
                ) 
            ),
            'search' => array (
                'advanced' => array (
                    'pagination' => 30,
                    'colorSensitivity' => 80, // in percentuale
                    'servicesCount' => 30, // in percentuale
                    'fields' => array (
                        'color' => array (
                            'show' => true,
                            'default' => 'no-color' 
                        ) 
                    ) 
                ) 
            ),
            // 'colors'=>array('no-color','#000000','#FFFFFF'),
            
            'users' => array (
                'password' => array (
                    'strength' => array (
                        'minLength' => 8, // lunghezza minima
                        'min1Upper' => true, // almeno una maiuscola
                        'min1Lower' => true, // almeno una minuscola
                        'min1Digit' => true, // almeno un numero
                        'min1Symbol' => true 
                    ) 
                ) 
            ), // almeno un simbolo, ad esempio: !()/\|,.-;:_ .... etc
            
            'alerts' => array (
                'rss' => array (
                    'version' => 'RSS1', // see EFeed::RSS1
                    'size' => 20,
                    'auth' => array (
                        'type' => 'open' 
                    ) 
                ), // see AlertController::RSS_AUTH_* constants
                
                'photoPreviewOnPlate' => false,
                'search' => array (
                    'dropdown_show_only_existent_tags' => true 
                ) 
            ),
            'notification' => array (
                'enabled' => true, // main switch!
                'max_per_stream' => 5, //
                'deleteFiltered' => false 
            ), // delete the notification filtered by NotificationController::filterNotification, otherwise they will be marked as 'dumped'
               // solo log4php
            'log4php' => array (
                'rootLogger' => array (
                    'appenders' => array () 
                ), // aggiungere 'socket' per splunk
                'eventserver-gui' => array (
                    'appenders' => array (
                        'default',
                        'socket' 
                    ) 
                ), // aggiungere 'socket' per splunk
                'appenders' => array (
                    'default' => array (
                        'class' => 'LoggerAppenderFile',
                        'layout' => array (
                            'class' => 'LoggerLayoutSimple' 
                        ),
                        'params' => array (
                            'file' => 'c:/testlog4php.log',
                            'append' => true 
                        ) 
                    ),
                    'socket' => array ( // splunk
                        'class' => 'LoggerAppenderSocket',
                        'layout' => array (
                            'class' => 'LoggerLayoutPattern',
                            'params' => array (
                                'conversionPattern' => '%date %logger %-5level %msg%n' 
                            ) 
                        ),
                        'params' => array (
                            'remoteHost' => '127.0.0.1', // '192.168.2.3',
                            'port' => 6101 
                        ) 
                    ),
                    'syslog' => array (
                        'class' => 'LoggerAppenderSyslog',
                        'layout' => array (
                            'class' => 'LoggerLayoutSimple' 
                        ),
                        'params' => array (
                            'ident' => 'eventserver-gui',
                            'facility' => 'USER',
                            'option' => 'NDELAY|PID' 
                        ) 
                    ) 
                ) 
            ) 
        ) 
    ), // fine log4php
       
    // fine params
    
    'configConsole' => array (
        'basePath' => dirname ( __FILE__ ) . DIRECTORY_SEPARATOR . '..',
        'name' => 'Event Server 3.0 - Console',
        
        'preload' => 'inherit',
        'import' => 'inherit',
        'modules' => 'inherit',
        'components' => 'inherit',
        'params' => 'inherit',
        
        'commandMap' => array (
            'database' => array (
                'class' => 'application.vendor.database-command.EDatabaseCommand' 
            ) 
        ) 
    ) 
);
