<?php

class HttpRequest extends CHttpRequest
{
  protected $_hostInfo;
  public function getHostInfo($schema='')
  {
    if ($this->_hostInfo === null)
    {
      if ($secure = $this->getIsSecureConnection())
      {
        $http = 'https';
      }
      else
      {
        $http = 'http';
      }
      if (isset($_SERVER['HTTP_X_FORWARDED_HOST']))
      {
        $this->_hostInfo = $http . '://' . $_SERVER['HTTP_X_FORWARDED_HOST'];
      }
      elseif (isset($_SERVER['HTTP_HOST']))
      {
        $this->_hostInfo = $http . '://' . $_SERVER['HTTP_HOST'];
      }
      else
      {
        $this->_hostInfo = $http . '://' . $_SERVER['SERVER_NAME'];
        $port = $_SERVER['SERVER_PORT'];
        if (($port != 80 && !$secure) || ($port != 443 && $secure))
        {
          $this->_hostInfo .= ':' . $port;
        }
      }
    }
    if ($schema !== '' && ($pos = strpos($this->_hostInfo, ':')) !== false) {
      return $schema . substr($this->_hostInfo, $pos);
    }
    else
    {
      return $this->_hostInfo;
    }
  }
}