$.ajaxSetup
  cache: false

$.datepicker.setDefaults( $.datepicker.regional[ settings.language ] )

$ ->

  $('.alphanumeric').keypress (e) ->
    regex = new RegExp('^[a-zA-Z0-9]+$')
    str = String.fromCharCode(if !e.charCode then e.which else e.charCode)
    if regex.test(str)
      return true
    e.preventDefault()
    false

  $('.alphanumericplate').keypress (e) ->
    regex = new RegExp('^[A-Z0-9]+$')
    str = String.fromCharCode(if !e.charCode then e.which else e.charCode)
    if regex.test(str)
      return true
    e.preventDefault()
    false

  $(".btnPrint").printPage()
  
  $("button.btn.toggleBtn[type='button']").each ->
    inputField = $($(this).data('target'))
    if(inputField.attr("value") == 1)
      $(this).addClass('active')
    else
      $(this).removeClass('active')
    $(this).click ->
      $(this).toggleClass('active')
      inputField = $($(this).data('target'))
      if $(this).hasClass('active')
        inputField.attr("value", 1)
      else
        inputField.attr("value", 0)
      false

  if ($('.kriatree_col').length > 0)
    $('.kriatree_col').click ->
      $('.kriatree').each ->
        el = $(this)
        divId = el.attr('id')+'_div'
        divName = '#'+divId
        elDiv = $(divName)
        if(elDiv.length > 0)
          if(!elDiv.is(':hidden'))
            elDiv.hide()

  if ($('.kriatree_exp').length > 0)
    $('.kriatree_exp').click ->
      $('.kriatree').each ->
        el = $(this)
        divId = el.attr('id')+'_div'
        divName = '#'+divId
        elDiv = $(divName)
        if(elDiv.length > 0)
          if(elDiv.is(':hidden'))
            elDiv.show()

  $('.kriatree').each ->
    li = $(this)
    li.click ->
      el = $(this)
      divId = el.attr('id')+'_div'
      divName = '#'+divId
      elDiv = $(divName)
      if(elDiv.length > 0)
        if(elDiv.is(':hidden'))
          elDiv.show()
        else
          elDiv.hide()

  $('.date-picker').datepicker()
  $('.datetime-picker').datetimepicker
    language: settings.language
    pickSeconds: false
    format: settings.datetimepicker_format

  $('.time-picker').datetimepicker
    language: settings.language
    pickSeconds: false
    pickDate: false
    format: settings.timepicker_format
      
  $('.dayofyear-picker').datetimepicker
    language: settings.language
    pickSeconds: false
    pickDate: true
    pickTime: false
    format: settings.dayofyearpicker_format

  $('.chzn-select').chosen
    allow_single_deselect: true

  getCurrentTime = ->
    today = new Date()
    
    year  = today.getFullYear()
    month = checkTime(today.getMonth()+1)
    day   = checkTime(today.getDate())
    hour = checkTime(today.getHours())
    minute = checkTime(today.getMinutes())
    second = checkTime(today.getSeconds())
    
    year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second
    
  checkTime = (i) ->
    i = "0" + i  if i < 10 # add zero in front of numbers < 10
    i

  # bar time 
  refreshClock = -> 
    $('#clock-bar').html(getCurrentTime())

  if ($('#clock-bar').length > 0)
    refreshClock()
    setInterval(refreshClock, 1000)

  #bar alert
  refreshAlertSummary = -> 
    $.get settings.baseUrl+"/alert/summary", (data) ->
      $('#alert-summary-bar').html(data)

  if ($('#alert-summary-bar').length > 0)
    refreshAlertSummary()
    setInterval(refreshAlertSummary, settings.system_status_refresh_time)
    
  #bar system
  refreshSystemSummary = -> 
    $.get settings.baseUrl+"/system/statusBox", (html) ->
      $('#system-status-bar').html(html)

  if ($('#system-status-bar').length > 0)
    refreshSystemSummary()
    setInterval(refreshSystemSummary, settings.system_status_refresh_time)

  #bar violation
  refreshViolationSummary = -> 
    $.get settings.baseUrl+"/event/statusBox", (html) ->
      $('#violation-status-bar').html(html)

  if ($('#violation-status-bar').length > 0)
    refreshViolationSummary()
    setInterval(refreshViolationSummary, settings.system_status_refresh_time)

  #bar stats
  refreshStatsSummary = -> 
    $.get settings.baseUrl+"/stats/statusBox", (html) ->
      $('#stats-status-bar').html(html)

  if ($('#stats-status-bar').length > 0)
    refreshStatsSummary()
    setInterval(refreshStatsSummary, settings.system_status_refresh_time)
   