<h3><?php echo htmlspecialchars(t('Last violations'),ENT_QUOTES,'UTF-8'); ?></h3>
<header>
  <div class="row clearfix">
    <div class="span5">
      <div class="gate-description">
        <?php if(isset($gate)) { ?>
          <p class="gate-name">
            <i class="icon-road"></i>
            <?php echo htmlspecialchars($gate->Descrizione,ENT_QUOTES,'UTF-8'); ?>
          </p>
        <?php } else { ?>
          <p class="gate-name"><?php echo htmlspecialchars(t('All gates selected'),ENT_QUOTES,'UTF-8'); ?></p>
        <?php } ?>
        <p class="update-time">
          <?php echo htmlspecialchars(t("Updated at:"),ENT_QUOTES,'UTF-8'); ?>
          <?php echo htmlspecialchars(DateHelper::formatLocalDateTime(),ENT_QUOTES,'UTF-8'); ?>
        </p>
      </div>
    </div>
    <div class="span3 pull-right">
      <div class="update-controls">
        <form class="form-inline">
          <label class="checkbox">
            <input class="automatic-violations-preview" type="checkbox" checked="checked"><?php echo htmlspecialchars(t('Automatic update'),ENT_QUOTES,'UTF-8'); ?></input>
          </label>
          <button class="update-violations-preview btn btn-small" type="button"><?php echo htmlspecialchars(t('Update'),ENT_QUOTES,'UTF-8'); ?></button>
        </form>
      </div>
    </div>
  </div>
</header>
<article class="violations">
  <?php if (count($violations)>0) { ?>
    <table class="table table-condensed">
      <thead>
        <tr>
          <th>
            <img width="16px" />
            <?php echo htmlspecialchars(t('License plate'),ENT_QUOTES,'UTF-8'); ?>
          </th>
          <th><?php echo htmlspecialchars(t('Gate'),ENT_QUOTES,'UTF-8'); ?></th>
          <th><?php echo htmlspecialchars(t('Date/Time'),ENT_QUOTES,'UTF-8'); ?></th>
          <th><?php echo htmlspecialchars(t('Km/h'),ENT_QUOTES,'UTF-8'); ?></th>
          <th><?php echo htmlspecialchars(t('Class'),ENT_QUOTES,'UTF-8'); ?></th>
          <th><?php echo htmlspecialchars(t('Colors'),ENT_QUOTES,'UTF-8'); ?></th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($violations as $violation) { ?>
          <?php $violationPresenter = new EventPresenter($violation);; ?>
          <?php $this->renderPartial('violations/_violationRow', array('violation' => $violationPresenter)); ?>
        <?php } ?>
      </tbody>
    </table>
  <?php } else { ?>
    <p><?php echo htmlspecialchars(t('No recent violations'),ENT_QUOTES,'UTF-8'); ?></p>
  <?php } ?>
</article>
<div id="modal-violation-photo-preview"></div>
