<?php $hasPermits=count($permessi)>0; ?>
<?php $validTransit=count($permessiAttivi)>0; ?>
<?php $fontColor=$validTransit ? "green" : "red"; ?>
<?php $transitValidityMessage= $validTransit ? t('authorized.') : t('not authorized.'); ?>
<div id="whitelist-smart-tips">
  <?php if($hasPermits) { ?>
    <h5>
      <?php echo htmlspecialchars(t('The vehicle has ').count($permessi).t(' plate authorizations, of which ').count($permessiAttivi).t(' actives. The transit is therefore '),ENT_QUOTES,'UTF-8'); ?>
      <font <?php echo MtHaml\Runtime::renderAttributes(array(array('color', $fontColor)), 'html5', 'UTF-8'); ?>>
        <?php echo htmlspecialchars($transitValidityMessage,ENT_QUOTES,'UTF-8'); ?>
      </font>
    </h5>
    <?php if($validTransit) { ?>
      <h5>
        <?php echo htmlspecialchars(t('This plate authorizations cancel the white list violation').':',ENT_QUOTES,'UTF-8'); ?>
      </h5>
      <?php if(AuthItem::countLike("plate_list_%")>0) { ?>
        <?php $printedPermit = 0; ?>
        <?php foreach($permessiAttivi as $p) { ?>
          <?php if($printedPermit > 0) { ?>
            <?php echo htmlspecialchars(',',ENT_QUOTES,'UTF-8'); ?>
          <?php } ?>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($p->url_view)), array('target', '_blank'), array('title', ($p->DescrizionePermesso))), 'html5', 'UTF-8'); ?>>
            <div class="icon-ok-circle"></div>
            <?php echo htmlspecialchars($p->IDPermesso,ENT_QUOTES,'UTF-8'); ?>
          </a>
          <?php $printedPermit++; ?>
        <?php } ?>
        <br />
      <?php } ?>
    <?php } ?>
  <?php } ?>
  <?php if(count($permessi)<=0) { ?>
    <h5>
      <?php echo htmlspecialchars(t('The vehicle has no plate authorization associated. The transit is therefore'),ENT_QUOTES,'UTF-8'); ?>
      <font <?php echo MtHaml\Runtime::renderAttributes(array(array('color', $fontColor)), 'html5', 'UTF-8'); ?>>
        <?php echo htmlspecialchars($transitValidityMessage,ENT_QUOTES,'UTF-8'); ?>
      </font>
    </h5>
  <?php } ?>
  <h5>
    <?php echo htmlspecialchars(t('Available actions:'),ENT_QUOTES,'UTF-8'); ?>
    <ul>
      <?php if($hasPermits) { ?>
        <li>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('target', '_blank'), array('href', (url('plateAuthorization/CheckWhitelistPlate', array('plate'=>$plate, 'time'=>tts($timestamp), 'nationality'=>$nationality, 'gate'=>$gate))))), 'html5', 'UTF-8'); ?>>
            <?php echo htmlspecialchars(t('Detailed authorizations analysis'),ENT_QUOTES,'UTF-8'); ?>
          </a>
        </li>
      <?php } ?>
      <li>
        <a data-toggle="modal" href="#" data-target="#white-list-modal"><?php echo htmlspecialchars(t('Quick lists management'),ENT_QUOTES,'UTF-8'); ?></a>
      </li>
    </ul>
  </h5>
</div>
<div id="white-list-modal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="white-list-modal" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button class="close" type="button" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><?php echo htmlspecialchars(t('Quick lists management'),ENT_QUOTES,'UTF-8'); ?></h3>
      </div>
      <div class="modal-body">
        <table class="table table-striped table-condensed" style="border: 1px solid grey">
          <tbody>
            <thead>
              <tr>
                <th>
                  <?php echo htmlspecialchars(t("Lista"),ENT_QUOTES,'UTF-8'); ?>
                </th>
                <th>
                  <?php echo htmlspecialchars(t("Action"),ENT_QUOTES,'UTF-8'); ?>
                </th>
              </tr>
            </thead>
            <?php foreach(PlateList::getCurrentUserWhiteLists() as $l) { ?>
              <?php if($l->editable) { ?>
                <tr>
                  <?php $listName = $l->getListTitle(); ?>
                  <td>
                    <?php echo htmlspecialchars($listName,ENT_QUOTES,'UTF-8'); ?>
                  </td>
                  <?php foreach(PlateAuthInsertProfile::model()->findAll() as $paip) { ?>
                    <?php if(user()->checkAccess("plate_auth_insert_profile_".$paip->id) && $l->editable && ($paip->list_code==-1 || $paip->list_code==$l->code)) { ?>
                      <td>
                        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('plateAuthorization/NewPlateAuthProfile', array('plateListId' => $l->code, 'plate'=>$plate, 'profileId'=>$paip->id)))), array('target', '_blank')), 'html5', 'UTF-8'); ?>>
                          <?php echo htmlspecialchars($paip->description,ENT_QUOTES,'UTF-8'); ?>
                        </a>
                      </td>
                    <?php } ?>
                  <?php } ?>
                  <td>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('target', '_blank'), array('href', (url('plateAuthorization/newWhitelist', array('plateListId'=>$l->code,'idIsCode'=>1, 'plate'=>$plate, 'refTimestamp'=>tts($timestamp), 'nationality'=>$nationality))))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t("Fast insert"),ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </td>
                </tr>
              <?php } ?>
            <?php } ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php if(paramdeep('validation','voidButton','enabled')) { ?>
  <?php if(count($permessiAttivi)>0) { ?>
    <script type="text/javascript">
    //<![CDATA[
      $(document).ready( function() {
        $('.btn-status-approved').addClass( 'hidden' );
        $('.btn-status-pending').addClass( 'hidden' );
        $('.btn-status-invalid').addClass( 'hidden' );
      } );
    //]]>
    </script>
  <?php } else { ?>
    <script type="text/javascript">
    //<![CDATA[
      $(document).ready( function() {
        $('.btn-status-approved').removeClass( 'hidden' );
        $('.btn-status-pending').removeClass( 'hidden' );
        $('.btn-status-invalid').removeClass( 'hidden' );
      } );
          
    //]]>
    </script>
  <?php } ?>
<?php } ?>
