<h3>
  <span>
    <?php echo htmlspecialchars(t('Violation documents'),ENT_QUOTES,'UTF-8'); ?>
  </span>
</h3>
<?php $user = is_numeric($event->ValidatedBy) ? User::model()->findByPk($event->ValidatedBy)->username : $event->ValidatedBy; ?>
<table class="table table-striped table-condensed">
  <tbody>
    <?php foreach ($event->eventBehaviors as $eventBehavior) { ?>
      <?php $currentBehavior = $eventBehavior->behavior->description; ?>
      <?php foreach ($eventBehavior->violationDocuments as $violationDocument) { ?>
        <tr>
          <td>
            <?php echo htmlspecialchars(t('Violation'),ENT_QUOTES,'UTF-8'); ?>
          </td>
          <td>
            <?php echo htmlspecialchars($currentBehavior,ENT_QUOTES,'UTF-8'); ?>
          </td>
        </tr>
        <tr>
          <td>
            <?php echo htmlspecialchars(t('Validation Time'),ENT_QUOTES,'UTF-8'); ?>
          </td>
          <td>
            <?php echo htmlspecialchars(DateHelper::formatLocalDate($event->ValidationTime),ENT_QUOTES,'UTF-8'); ?>
            <?php echo htmlspecialchars(DateHelper::formatISO9075Time($event->ValidationTime),ENT_QUOTES,'UTF-8'); ?>
          </td>
        </tr>
        <tr>
          <td>
            <?php echo htmlspecialchars(t('Validated By'),ENT_QUOTES,'UTF-8'); ?>
          </td>
          <td>
            <?php echo htmlspecialchars($user,ENT_QUOTES,'UTF-8'); ?>
          </td>
        </tr>
        <tr>
          <td>
            <?php echo htmlspecialchars(t('Type'),ENT_QUOTES,'UTF-8'); ?>
          </td>
          <td>
            <?php echo htmlspecialchars(t($violationDocument->status),ENT_QUOTES,'UTF-8'); ?>
            <?php if($violationDocument->status !== 'missing' && $violationDocument->status !== 'failed' && $violationDocument->status !== 'invalid') { ?>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'icon-eye-open'), array('href', ($this->createUrl('Event/violationDocumentPreview', array('violationDocumentId'=>$violationDocument->id)))), array('target', '_blank')), 'html5', 'UTF-8'); ?>></a>
            <?php } ?>
          </td>
        </tr>
        <tr>
          <td>
            <?php echo htmlspecialchars('ADI',ENT_QUOTES,'UTF-8'); ?>
          </td>
          <td>
            <?php echo htmlspecialchars($event->Protocol,ENT_QUOTES,'UTF-8'); ?>
          </td>
        </tr>
        <tr>
          <td>
            <?php echo htmlspecialchars(t('Comment'),ENT_QUOTES,'UTF-8'); ?>
          </td>
          <td>
            <?php echo htmlspecialchars($eventBehavior->comment,ENT_QUOTES,'UTF-8'); ?>
          </td>
        </tr>
      <?php } ?>
    <?php } ?>
  </tbody>
</table>
