<?php $app = Yii::app(); ?>
<?php $user = $app->user; ?>
<?php $homeUrl = $app->homeUrl; ?>
<?php $controller = $app->controller; ?>
<div id="myCanvasContainer">
  <canvas id="myCanvas" width="1000" height="600">
    <p>Anything in here will be replaced on browsers that support the canvas element</p>
    <ul>
      <li>
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', 'http://www.kria.biz'), array('target', ('_blank'))), 'html5', 'UTF-8'); ?>>
          <img <?php echo MtHaml\Runtime::renderAttributes(array(array('src', ((Yii::app()->baseUrl) . '/images/kria_logo.png'))), 'html5', 'UTF-8'); ?> />
        </a>
      </li>
      <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof DashboardController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $homeUrl)), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','dashboard'),Yii::t("app", "Home")),ENT_QUOTES,'UTF-8'); ?></a>
      </li>
      <?php if (Yii::app()->user->checkAccess('view_gates_status')) { ?>
        <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof GatesStatusController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('gatesStatus')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','gateStatus'),Yii::t("app", 'Gates Status')),ENT_QUOTES,'UTF-8'); ?></a>
        </li>
      <?php } ?>
      <?php if (Yii::app()->user->checkAccess('view_alerts')) { ?>
        <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof AlertController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('alert/search')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','alerts'),Yii::t('app', 'Alerts')),ENT_QUOTES,'UTF-8'); ?></a>
        </li>
      <?php } ?>
      <?php if (Yii::app()->user->checkAccess('view_map')) { ?>
        <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof CartographyController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('cartography')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','map'),Yii::t('app', 'Maps')),ENT_QUOTES,'UTF-8'); ?></a>
        </li>
      <?php } ?>
      <?php if (Yii::app()->user->checkAccess('view_live')) { ?>
        <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof LiveController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('live')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','live'),Yii::t('app', 'Live')),ENT_QUOTES,'UTF-8'); ?></a>
        </li>
      <?php } ?>
      <?php if (Yii::app()->user->checkAccess('verify_events') || Yii::app()->user->checkAccess('check_events_data')) { ?>
        <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof ServiceController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('service')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','services'),Yii::t('app', 'Tasks')),ENT_QUOTES,'UTF-8'); ?></a>
        </li>
      <?php } ?>
      <?php if (Yii::app()->user->checkAccess('search_violations')) { ?>
        <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof SearchController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('search')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Detections - Fast search'),ENT_QUOTES,'UTF-8'); ?></a>
        </li>
      <?php } ?>
      <?php if (Yii::app()->user->checkAccess('search_violations_advanced')) { ?>
        <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof EventController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('event/admin')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Detections - Advanced search'),ENT_QUOTES,'UTF-8'); ?></a>
        </li>
      <?php } ?>
      <?php if (Yii::app()->user->checkAccess('search_transits')) { ?>
        <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof VehicleTraceController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('vehicleTrace/admin')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Transits'),ENT_QUOTES,'UTF-8'); ?></a>
        </li>
      <?php } ?>
      <?php if($user->checkAccess('statistics')) { ?>
        <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof StatsController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('stats')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','stats'),Yii::t('app', 'Stats')),ENT_QUOTES,'UTF-8'); ?></a>
        </li>
      <?php } ?>
      <?php if($user->checkAccessLike('plate_list_*')) { ?>
        <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof PlateAuthorizationController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('plateAuthorization')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(getBWListsLabels(paramdeep('menuTitles','plateAuthorizationWL'),paramdeep('menuTitles','plateAuthorizationBL'),paramdeep('menuTitles','plateAuthorizationBWL')),ENT_QUOTES,'UTF-8'); ?></a>
        </li>
      <?php } ?>
      <?php if(paramdeep('ztl','active') && Yii::app()->user->checkAccess('ztl_view')) { ?>
        <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof ZtlController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('ztl/index')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','ztl'),Yii::t('app', paramdeep('ztl','name'))),ENT_QUOTES,'UTF-8'); ?></a>
        </li>
      <?php } ?>
      <?php if($user->checkAccess('manage_gates') || $user->checkAccess('manage_auth') || $user->checkAccess('manage_users') || $user->checkAccess('manage_special_day') || $user->checkAccess('manage_time_schedule')) { ?>
        <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof AdminController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($app->createUrl('admin')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(onNull(paramdeep('menuTitles','admin'),Yii::t('app', 'Admin')),ENT_QUOTES,'UTF-8'); ?></a>
        </li>
      <?php } ?>
      <?php if((user()->isGuest && paramdeep('support','visible_to_guest')) || (!user()->isGuest && paramdeep('support','visible_to_user')))  { ?>
        <li <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ($controller instanceof SupportController ? 'active' : ''))), 'html5', 'UTF-8'); ?>>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (t('Support'))), array('href', ($app->createUrl('support')))), 'html5', 'UTF-8'); ?>>
            <div class="icon-question-sign"></div>
          </a>
        </li>
      <?php } ?>
    </ul>
  </canvas>
</div>
