<?php $preferences = param('gateStatus'); ?>
<?php $lastViolationMinutes = $preferences['lastViolationMinutes'];; ?>
<?php $hours = $lastViolationMinutes / 60; ?>
<?php $days = $hours / 24; ?>
<h3>
  <?php echo htmlspecialchars(t('Gates'),ENT_QUOTES,'UTF-8'); ?>
  <small>
    <?php if($days >= 1) { ?>
      <?php echo htmlspecialchars(t('Last {qty_days} days summary', array('{qty_days}' => $days)),ENT_QUOTES,'UTF-8'); ?>
    <?php } else { ?>
      <?php echo htmlspecialchars(t('Last {qty_hours} hours summary', array('{qty_hours}' => $hours)),ENT_QUOTES,'UTF-8'); ?>
    <?php } ?>
  </small>
</h3>
<div class="gate-list-update-info">
  <span>
    <?php echo htmlspecialchars(t('Updated at:'),ENT_QUOTES,'UTF-8'); ?>
  </span>
  <span id="gate-last-update-time">
    <?php echo htmlspecialchars(DateHelper::formatLocalDateTime(),ENT_QUOTES,'UTF-8'); ?>
  </span>
</div>
<script type="text/javascript" src="js/closableGates.js"></script>
<div id="gates-container">
  <?php if(!is_null($gateGroups) && count($gateGroups)>0)       { ?>
    <?php foreach($gateGroups as $gateGroup) { ?>
      <?php $gateGroup = new GateGroupPresenter($gateGroup); ?>
      <div class="gate-group-all panel panel-default">
        <div class="gate-group-all-name panel-heading">
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('gate-group-all-name' . ' ' . 'panel-heading' . ' ' . 'custom-head')), array('data-toggle', 'collapse'), array('href', ('#' . ($gateGroup->ID))), array('class', ($gateGroup->getStatusClass()))), 'html5', 'UTF-8'); ?>>
            <span <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'panel-title'), array('title', (t('Gate group')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars($gateGroup->name,ENT_QUOTES,'UTF-8'); ?></span>
          </a>
        </div>
        <div <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('panel-collapse' . ' ' . 'collapse')), array('id', ($gateGroup->ID)), array('class', ('collapse ' . ($gateGroup->getStatusClass())))), 'html5', 'UTF-8'); ?>>
          <div class="spinner">
            <div class="bounce1"></div>
            <div class="bounce2"></div>
            <div class="bounce3"></div>
          </div>
        </div>
      </div>
    <?php } ?>
  <?php } ?>
</div>
