<!DOCTYPE html>
<?php $app = Yii::app(); ?>
<?php $baseUrl = $app->request->baseUrl; ?>
<html>
  <head>
    <meta http-equiv="Content-type" content="text/html; charset=UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <?php $app->bootstrap->register() #it must be before %title; ?>
    <title><?php echo htmlspecialchars($this->pageTitle,ENT_QUOTES,'UTF-8'); ?></title>
    <link <?php echo MtHaml\Runtime::renderAttributes(array(array('rel', 'stylesheet'), array('type', 'text/css'), array('href', ($baseUrl . '/css/application.min.css'))), 'html5', 'UTF-8'); ?> />
    <link <?php echo MtHaml\Runtime::renderAttributes(array(array('rel', 'shortcut icon'), array('href', ($baseUrl . '/favicon.ico'))), 'html5', 'UTF-8'); ?> />
    <script>
      var settings = {        baseUrl: "<?php echo htmlspecialchars($baseUrl,ENT_QUOTES,'UTF-8'); ?>"}
    </script>
    <!--[if lt IE 9]>
      <script type="text/javascript" src="/js/html5shiv.js"></script>
      <script type="text/javascript" src="/js/respond.min.js"></script>
    <![endif]-->
    <script <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text/javascript'), array('src', ($baseUrl . '/js/application.min.js'))), 'html5', 'UTF-8'); ?>></script>
  </head>
  <body class="print">
    <div class="container">
      <div id="content">
        <?php echo $content; ?>
      </div>
    </div>
  </body>
</html>
