<?php $nowISO = DateHelper::formatISO9075DateTime(); ?>
<?php $eventDate = $event->StartTime->format(DateHelper::ISO9075_DATE); ?>
<?php $eventTime = $event->StartTime->format(DateHelper::ISO9075_TIME); ?>
<?php $veichleClasses = VehicleTypes::localized(); ?>
<?php $nations = CountryList::localized();; ?>
<?php $challengedSpeed = number_format(CalculateChallengedSpeed::run($event->Speed, Yii::app()->params['spotSpeedViolation']['percentageTolerance'], Yii::app()->params['spotSpeedViolation']['fixedTolerance'], Yii::app()->params['spotSpeedViolation']['toleranceTable']), 2); ?>
<?php $this->setPageTitle("Dettagli Evento #{$event->ID} del giorno {$eventDate} alle ore {$eventTime}"); ?>
<header class="report">
  <img <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'torino'), array('src', ((Yii::app()->baseUrl) . '/images/' . (paramdeep('event','report','logo'))))), 'html5', 'UTF-8'); ?> />
  <h2><?php echo htmlspecialchars(paramdeep('event','report','text') ,ENT_QUOTES,'UTF-8'); ?></h2>
  <h5>
    STAMPA INFRAZIONE IN ACCERTAMENTO (velocità istantanea)
  </h5>
</header>
<section class="reportcontent">
  <div class="vehicle-data">
    <table class="table event-info">
      <tbody>
        <tr>
          <td><?php echo htmlspecialchars(Yii::t('app', 'Allowed Speed'),ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($event->speed_limit,ENT_QUOTES,'UTF-8'); ?></td>
        </tr>
        <tr>
          <td><?php echo htmlspecialchars(Yii::t('app', 'Contested Speed'),ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($challengedSpeed,ENT_QUOTES,'UTF-8'); ?></td>
        </tr>
        <tr>
          <td><?php echo htmlspecialchars(Yii::t('app', 'External Code'),ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($event->ext_code,ENT_QUOTES,'UTF-8'); ?></td>
        </tr>
        <tr>
          <td><?php echo htmlspecialchars(Yii::t('app', 'Event ID'),ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($event->ID,ENT_QUOTES,'UTF-8'); ?></td>
        </tr>
        <tr>
          <td><?php echo htmlspecialchars(Yii::t('app', 'Date'),ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($event->StartTime->format(DateHelper::ISO9075_DATE),ENT_QUOTES,'UTF-8'); ?></td>
        </tr>
        <tr>
          <td><?php echo htmlspecialchars(Yii::t('app', 'Time'),ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($event->StartTime->format(DateHelper::ISO9075_TIME),ENT_QUOTES,'UTF-8'); ?></td>
        </tr>
      </tbody>
    </table>
    <table class="table vehicle-info">
      <tbody>
        <tr>
          <td><?php echo htmlspecialchars(Yii::t('app', 'License plate'),ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($event->Plate,ENT_QUOTES,'UTF-8'); ?></td>
        </tr>
        <tr>
          <td><?php echo htmlspecialchars(Yii::t('app', 'Vehicle type'),ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($veichleClasses[$event->custom_vehicle_type],ENT_QUOTES,'UTF-8'); ?></td>
        </tr>
        <tr>
          <td><?php echo htmlspecialchars(Yii::t('app', 'Nationality'),ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($nations[$event->custom_nationality],ENT_QUOTES,'UTF-8'); ?></td>
        </tr>
        <tr>
          <td><?php echo htmlspecialchars(Yii::t('app', 'License Plate Type'),ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($event->custom_plate_type,ENT_QUOTES,'UTF-8'); ?></td>
        </tr>
        <tr>
          <td><?php echo htmlspecialchars(Yii::t('app', 'Type'),ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($event->custom_property_type,ENT_QUOTES,'UTF-8'); ?></td>
        </tr>
        <tr>
          <td><?php echo htmlspecialchars(Yii::t('app', 'Kemler'),ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($event->Kemler,ENT_QUOTES,'UTF-8'); ?></td>
        </tr>
      </tbody>
    </table>
  </div>
  <div class="vehicle-image">
    <center>
      <div class="locality">
        <?php echo htmlspecialchars($event->GateDescription,ENT_QUOTES,'UTF-8'); ?>
      </div>
      <img <?php echo MtHaml\Runtime::renderAttributes(array(array('src', $photoReportUrl)), 'html5', 'UTF-8'); ?> />
    </center>
  </div>
  <p>Sistema di misura della velocità T-EXSPEED v.2.0, omologa del Ministero delle Infrastrutture e dei Trasporti con D.M. n° 5298 del 27/10/2011</p>
</section>
