<?php $currentUrl = Yii::app()->createAbsoluteUrl($this->route,$context); ?>
<?php $hasData = isset($owners) && count($owners->data)>0; ?>
<div class="page-header">
  <h2>
    <i class="icon-user"></i>
    <?php echo htmlspecialchars(t('Vehicle owners'),ENT_QUOTES,'UTF-8'); ?>
  </h2>
</div>
<h5>
  <?php $navigate_url_list = Yii::app()->createAbsoluteUrl('plateAuthorization'); ?>
  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $navigate_url_list)), 'html5', 'UTF-8'); ?>>
    <i class="icon-file-text-alt"></i>
    <?php echo htmlspecialchars($objList->name,ENT_QUOTES,'UTF-8'); ?>
  </a>
  <i class="icon-long-arrow-right"></i>
  <i class="icon-user"></i>
  <?php echo htmlspecialchars(t('Select owner'),ENT_QUOTES,'UTF-8'); ?>
  <i class="icon-long-arrow-right"></i>
  <font color="gray">
    <i class="icon-truck"></i>
    <?php echo htmlspecialchars(t('Select vehicle'),ENT_QUOTES,'UTF-8'); ?>
  </font>
  <i class="icon-long-arrow-right"></i>
  <font color="gray">
    <i class="icon-time"></i>
    <?php echo htmlspecialchars(t('Select validity period'),ENT_QUOTES,'UTF-8'); ?>
  </font>
  <i class="icon-long-arrow-right"></i>
  <font color="gray">
    <i class="icon-ok-circle"></i>
    <?php echo htmlspecialchars(t('Select plate authorization'),ENT_QUOTES,'UTF-8'); ?>
  </font>
</h5>
<?php $goback_url = Yii::app()->createAbsoluteUrl('plateAuthorization'); ?>
<br />
<div class="row">
  <div class="form-box">
    <?php $form = $this->beginWidget('bootstrap.widgets.TbActiveForm',      array('id'=>'vehicleowner-search-form','action' => Yii::app()->createUrl($this->route),'method' => 'GET',)); ?>
    <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'plateListId'), array('value', $plateListId)), 'html5', 'UTF-8'); ?> />
    <input type="hidden" name="step" value="1" />
    <input type="hidden" name="action" value="search" />
    <h3>
      <?php echo htmlspecialchars(t("Search vehicle owner"),ENT_QUOTES,'UTF-8'); ?>
    </h3>
    <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text'), array('name', 'what'), array('value', $what)), 'html5', 'UTF-8'); ?> />
    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $currentUrl)), 'html5', 'UTF-8'); ?>>
      <i class="icon-remove-sign"></i>
    </a>
    <?php $this->endWidget(); ?>
    <?php if ($hasData) { ?>
      <div class="tableContainer pagination-data-container">
        <table class="table table-condensed">
          <thead>
            <tr>
              <th></th>
              <th><?php echo htmlspecialchars(VehicleOwner::model()->getAttributeLabel('Nome'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(VehicleOwner::model()->getAttributeLabel('Cognome'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(VehicleOwner::model()->getAttributeLabel('epoch'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(t('Actions'),ENT_QUOTES,'UTF-8'); ?></th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($owners->data as $owner) { ?>
              <?php $owner_url = Yii::app()->createAbsoluteUrl($this->route,array('plateListId'=>$plateListId,'step'=>'2','ownerId'=>$owner->ID)); ?>
              <?php $delete_url = Yii::app()->createUrl('plateAuthorization/whiteListWizardDelete',array('listId'=>$plateListId, 'objType'=>'owner', 'objId'=>$owner->ID, 'returnUrl'=>$currentUrl)); ?>
              <tr>
                <td>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $owner_url)), 'html5', 'UTF-8'); ?>>
                    <i class="icon-eye-open"></i>
                  </a>
                </td>
                <td>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $owner_url)), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars($owner->Nome,ENT_QUOTES,'UTF-8'); ?>
                  </a>
                </td>
                <td>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $owner_url)), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars($owner->Cognome,ENT_QUOTES,'UTF-8'); ?>
                  </a>
                </td>
                <td>
                  <?php echo htmlspecialchars($owner->epoch,ENT_QUOTES,'UTF-8'); ?>
                </td>
                <td>
                  <?php if(user()->checkAccess('vehicle_owner_management') && user()->checkAccess('vehicle_owner_update')) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('vehicleOwner/update', array('id'=>$owner->ID))))), 'html5', 'UTF-8'); ?>>
                      <i class="icon-pencil"></i>
                    </a>
                  <?php } ?>
                  <?php if(Yii::app()->user->checkAccess("plate_auth_delete")) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $delete_url), array('onclick', ('return confirm(\'' . (t('Are you sure you want to delete this item?')) . '\')'))), 'html5', 'UTF-8'); ?>>
                      <i class="icon-trash"></i>
                    </a>
                  <?php } ?>
                </td>
              </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
      <?php if (isset($owners->pagination)) { ?>
        <div class="pagination pagination-links-container">
          <?php $this->widget('bootstrap.widgets.TbPager', array('pages' => $owners->pagination)); ?>
        </div>
      <?php } ?>
    <?php } else { ?>
      <h4><?php echo htmlspecialchars(Yii::t("app", "No results"),ENT_QUOTES,'UTF-8'); ?></h4>
    <?php } ?>
  </div>
</div>
<?php if(true) { ?>
  <br />
  <div class="row">
    <div class="form-box">
      <?php $form = $this->beginWidget('bootstrap.widgets.TbActiveForm',      array('id'=>'vehicleowner-create-form','action' => Yii::app()->createUrl($this->route),'method' => 'POST',)); ?>
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'plateListId'), array('value', $plateListId)), 'html5', 'UTF-8'); ?> />
      <input type="hidden" name="step" value="1" />
      <input type="hidden" name="action" value="create" />
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'create_confirmed'), array('value', ($properties[create_confirmed]))), 'html5', 'UTF-8'); ?> />
      <h3><?php echo htmlspecialchars(t("Create vehicle owner"),ENT_QUOTES,'UTF-8'); ?></h3>
      <h5>
        <?php echo htmlspecialchars(VehicleOwner::model()->getAttributeLabel('Nome'),ENT_QUOTES,'UTF-8'); ?>
        <font color="red"><?php echo htmlspecialchars('*',ENT_QUOTES,'UTF-8'); ?></font>
      </h5>
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text'), array('name', 'name'), array('value', ($properties[owner_confirmation_name]))), 'html5', 'UTF-8'); ?> />
      <h5>
        <?php echo htmlspecialchars(VehicleOwner::model()->getAttributeLabel('Cognome'),ENT_QUOTES,'UTF-8'); ?>
        <font color="red"><?php echo htmlspecialchars('*',ENT_QUOTES,'UTF-8'); ?></font>
      </h5>
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text'), array('name', 'surname'), array('value', ($properties[owner_confirmation_surname]))), 'html5', 'UTF-8'); ?> />
      <br />
      <br />
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'submit'), array('name', 'create'), array('value', (t('Create')))), 'html5', 'UTF-8'); ?> />
      <?php $this->endWidget(); ?>
    </div>
  </div>
<?php } ?>
<br />
<a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $goback_url)), 'html5', 'UTF-8'); ?>>
  <h4><?php echo htmlspecialchars(t('Go back')     ,ENT_QUOTES,'UTF-8'); ?></h4>
</a>
