<?php $isBlack = $plateList->mode == PlateList::MODE_BLACK_LIST; ?>
<?php if($isBlack) { ?>
  <?php $imgurl = $plateList->getImageUrl('/images/list_black.png'); ?>
<?php } else { ?>
  <?php $imgurl = $plateList->getImageUrl('/images/list_white.png'); ?>
<?php } ?>
<h3>
  <?php echo htmlspecialchars(t('List'),ENT_QUOTES,'UTF-8'); ?>
  <?php echo htmlspecialchars('#',ENT_QUOTES,'UTF-8'); ?>
  <?php echo htmlspecialchars($plateList->getListTitle(),ENT_QUOTES,'UTF-8'); ?>
  <?php if(!empty($imgurl)) { ?>
    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $imgurl)), 'html5', 'UTF-8'); ?>>
      <img <?php echo MtHaml\Runtime::renderAttributes(array(array('src', $imgurl), array('width', '100'), array('align', 'right')), 'html5', 'UTF-8'); ?> />
    </a>
  <?php } ?>
</h3>
<table class="table table-striped span6">
  <thead>
    <tr>
      <th class="span3"></th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Name'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($plateList->name,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Source'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($plateList->source,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Code'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($plateList->code,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Title'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($plateList->title,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <?php if(user()->checkAccess('plate_list_management')) { ?>
      <tr>
        <td>
          <?php echo htmlspecialchars(t('Mode'),ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php echo htmlspecialchars($plateList->mode         ,ENT_QUOTES,'UTF-8'); ?>
        </td>
      </tr>
      <tr>
        <td>
          <?php echo htmlspecialchars(t('Editable'),ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php if($plateList->editable) { ?>
            <?php echo htmlspecialchars(t('Yes'),ENT_QUOTES,'UTF-8'); ?>
          <?php } else { ?>
            <?php echo htmlspecialchars(t('No')       ,ENT_QUOTES,'UTF-8'); ?>
          <?php } ?>
        </td>
      </tr>
      <tr>
        <td>
          <?php echo htmlspecialchars(t('Visible'),ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php if($plateList->visible) { ?>
            <?php echo htmlspecialchars(t('Yes'),ENT_QUOTES,'UTF-8'); ?>
          <?php } else { ?>
            <?php echo htmlspecialchars(t('No')         ,ENT_QUOTES,'UTF-8'); ?>
          <?php } ?>
        </td>
      </tr>
      <tr>
        <td>
          <?php echo htmlspecialchars(t('Auto import'),ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php if($plateList->auto_import) { ?>
            <?php echo htmlspecialchars(t('Yes'),ENT_QUOTES,'UTF-8'); ?>
          <?php } else { ?>
            <?php echo htmlspecialchars(t('No'),ENT_QUOTES,'UTF-8'); ?>
          <?php } ?>
        </td>
      </tr>
      <?php if($plateList->auto_import)       { ?>
        <tr>
          <td>
            <?php echo htmlspecialchars(t('Import Type'),ENT_QUOTES,'UTF-8'); ?>
          </td>
          <td>
            <?php echo htmlspecialchars($plateList->import_type        ,ENT_QUOTES,'UTF-8'); ?>
          </td>
        </tr>
        <tr>
          <td>
            <?php echo htmlspecialchars(t('Import Folder'),ENT_QUOTES,'UTF-8'); ?>
          </td>
          <td>
            <?php echo htmlspecialchars($plateList->import_folder,ENT_QUOTES,'UTF-8'); ?>
          </td>
        </tr>
      <?php } ?>
      <tr>
        <td>
          <?php echo htmlspecialchars(t('Autoconfirm'),ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php if($plateList->autoconfirm) { ?>
            <?php echo htmlspecialchars(t('Yes'),ENT_QUOTES,'UTF-8'); ?>
          <?php } else { ?>
            <?php echo htmlspecialchars(t('No'),ENT_QUOTES,'UTF-8'); ?>
          <?php } ?>
        </td>
      </tr>
      <?php if($plateList->autoconfirm && $plateList->autoconfirm_wait!=null)       { ?>
        <tr>
          <td>
            <?php echo htmlspecialchars(t('Autoconfirm interval'),ENT_QUOTES,'UTF-8'); ?>
          </td>
          <td>
            <?php echo htmlspecialchars($plateList->autoconfirm_wait,ENT_QUOTES,'UTF-8'); ?>
          </td>
        </tr>
      <?php } ?>
      <tr>
        <td>
          <?php echo htmlspecialchars(t('Minimum duration'),ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php echo htmlspecialchars($plateList->mintime,ENT_QUOTES,'UTF-8'); ?>
        </td>
      </tr>
      <tr>
        <td>
          <?php echo htmlspecialchars(t('Maximum duration'),ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php echo htmlspecialchars($plateList->maxtime,ENT_QUOTES,'UTF-8'); ?>
        </td>
      </tr>
      <tr>
        <td>
          <?php echo htmlspecialchars(t('Maximum size'),ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php echo htmlspecialchars($plateList->maxsize,ENT_QUOTES,'UTF-8'); ?>
        </td>
      </tr>
    <?php } ?>
  </tbody>
</table>
