<?php

/**
 * This is the model class for table "images_roi".
 *
 * The followings are the available columns in table 'images_roi':
 * @property integer $id
 * @property integer $image_id
 * @property integer $event_id
 * @property string $src_image_type
 * @property double $roi_x
 * @property double $roi_y
 * @property double $roi_width
 * @property double $roi_height
 * @property string $action
 */
class ImagesRoi extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'images_roi';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('image_id, event_id, src_image_type, roi_x, roi_y, roi_width, roi_height, action', 'required'),
            array('image_id, event_id', 'numerical', 'integerOnly'=>true),
            array('roi_x, roi_y, roi_width, roi_height', 'numerical'),
            array('src_image_type, action', 'length', 'max'=>45),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, image_id, event_id, src_image_type, roi_x, roi_y, roi_width, roi_height, action', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'image_id' => 'Image',
            'event_id' => 'Event',
            'src_image_type' => 'Src Image Type',
            'roi_x' => 'Roi X',
            'roi_y' => 'Roi Y',
            'roi_width' => 'Roi Width',
            'roi_height' => 'Roi Height',
            'action' => 'Action',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id',$this->id);
        $criteria->compare('image_id',$this->image_id);
        $criteria->compare('event_id',$this->event_id);
        $criteria->compare('src_image_type',$this->src_image_type,true);
        $criteria->compare('roi_x',$this->roi_x);
        $criteria->compare('roi_y',$this->roi_y);
        $criteria->compare('roi_width',$this->roi_width);
        $criteria->compare('roi_height',$this->roi_height);
        $criteria->compare('action',$this->action,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return ImagesRoi the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
}