<?php

/*
 * Define ReportPrinterFactory Component to build and return the proper
 * ReportPrinter according to app configuration parameters
 */
class ReportPrinterFactory extends CComponent
{
	public static function getReportPrinter() {
		
		// get our params from global configurations
		$printerFactoryParams = Yii::app()->params['ReportPrinterFactory'];
		
		// check user defined params to build the proper report printer
		if (isset($printerFactoryParams['ReportPrinter'])) {
			
			// get user defined report printer class name
			$reportPrinterClass = $printerFactoryParams['ReportPrinter'];
			
		}
		else {
			
			// use default report printer class
			$reportPrinterClass = 'ReportPrinter';
			
		}
		
		// build the proper report printer
		$reportPrinter = new $reportPrinterClass();
		
		// return it
		return $reportPrinter;
		
	}
}

?>