<?php $currentUrl = Yii::app()->createAbsoluteUrl($this->route,$context); ?>
<?php $vehicleSources = paramdeep('plateAuthorizations','vehicleSources'); ?>
<?php if($vehicleSources == null || count($vehicleSources) <= 0) { ?>
  <?php $vehicleSources = array(); ?>
<?php } else { ?>
  <?php $vehicleSources = array_merge(array('' => ''), $vehicleSources); ?>
<?php } ?>
<?php $hasData = isset($vehicles) && count($vehicles->data)>0; ?>
<?php $paramDescription = array_get($_REQUEST,"v_description"); ?>
<?php $paramNationality = array_get($_REQUEST,"v_nationality"); ?>
<?php $paramClass = array_get($_REQUEST,"v_class"); ?>
<?php $paramSource = array_get($_REQUEST,"v_source",paramdeep('plateAuthorizations','default','vehicleSource')); ?>
<?php $paramAction = array_get($_REQUEST,"v_action"); ?>
<?php $paramNote = array_get($_REQUEST,"v_note"); ?>
<?php if(count($vehicleSources)>0) { ?>
  <?php if(!array_key_exists(paramdeep('plateAuthorizations','default','vehicleSource'),$vehicleSources)) { ?>
    <?php $vehicleSources[paramdeep('plateAuthorizations','default','vehicleSource')] = paramdeep('plateAuthorizations','default','vehicleSource'); ?>
  <?php } ?>
<?php } ?>
<div class="page-header">
  <h2>
    <i class="icon-truck"></i>
    <?php echo htmlspecialchars(t('Vehicles'),ENT_QUOTES,'UTF-8'); ?>
  </h2>
</div>
<h5>
  <?php $navigate_url_list = Yii::app()->createAbsoluteUrl('plateAuthorization'); ?>
  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $navigate_url_list)), 'html5', 'UTF-8'); ?>>
    <i class="icon-file-text-alt"></i>
    <?php echo htmlspecialchars($objList->name,ENT_QUOTES,'UTF-8'); ?>
  </a>
  <?php $navigate_url_user = Yii::app()->createAbsoluteUrl($this->route,array('plateListId'=>$plateListId,'step'=>'1')); ?>
  <i class="icon-long-arrow-right"></i>
  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $navigate_url_user)), 'html5', 'UTF-8'); ?>>
    <i class="icon-user"></i>
    <?php echo htmlspecialchars("$objOwner->Nome $objOwner->Cognome",ENT_QUOTES,'UTF-8'); ?>
  </a>
  <i class="icon-long-arrow-right"></i>
  <i class="icon-truck"></i>
  <?php echo htmlspecialchars(t('Select vehicle'),ENT_QUOTES,'UTF-8'); ?>
  <i class="icon-long-arrow-right"></i>
  <font color="gray">
    <i class="icon-time"></i>
    <?php echo htmlspecialchars(t('Select validity period'),ENT_QUOTES,'UTF-8'); ?>
  </font>
  <i class="icon-long-arrow-right"></i>
  <font color="gray">
    <i class="icon-ok-circle"></i>
    <?php echo htmlspecialchars(t('Select plate authorization'),ENT_QUOTES,'UTF-8'); ?>
  </font>
</h5>
<?php $goback_url = Yii::app()->createAbsoluteUrl($this->route,array('plateListId'=>$plateListId,'step'=>'1')); ?>
<div class="row">
  <div class="form-box">
    <?php $form = $this->beginWidget('bootstrap.widgets.TbActiveForm',      array('id'=>'vehicle-search-form','action' => Yii::app()->createUrl($this->route),'method' => 'GET',)); ?>
    <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'plateListId'), array('value', $plateListId)), 'html5', 'UTF-8'); ?> />
    <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'ownerId'), array('value', $ownerId)), 'html5', 'UTF-8'); ?> />
    <input type="hidden" name="step" value="2" />
    <input type="hidden" name="action" value="search" />
    <h3>
      <?php echo htmlspecialchars(t("Search vehicle"),ENT_QUOTES,'UTF-8'); ?>
    </h3>
    <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text'), array('name', 'what'), array('value', $what)), 'html5', 'UTF-8'); ?> />
    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $currentUrl)), 'html5', 'UTF-8'); ?>>
      <i class="icon-remove-sign"></i>
    </a>
    <?php $this->endWidget(); ?>
    <?php if ($hasData) { ?>
      <div class="tableContainer pagination-data-container">
        <table class="table table-condensed">
          <thead>
            <tr>
              <th></th>
              <th><?php echo htmlspecialchars(Vehicle::model()->getAttributeLabel('Descrizione'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(Vehicle::model()->getAttributeLabel('Targa'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(Vehicle::model()->getAttributeLabel('Nationality'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(Vehicle::model()->getAttributeLabel('Classe'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(Vehicle::model()->getAttributeLabel('category'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(Vehicle::model()->getAttributeLabel('epoch'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(t('Actions'),ENT_QUOTES,'UTF-8'); ?></th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($vehicles->data as $vehicle) { ?>
              <?php $vehicle_url = Yii::app()->createAbsoluteUrl($this->route,array('plateListId'=>$plateListId,'step'=>'3','ownerId'=>$ownerId,'vehicleId'=>$vehicle->ID)); ?>
              <?php $delete_url = Yii::app()->createUrl('plateAuthorization/whiteListWizardDelete',array('listId'=>$plateListId, 'objType'=>'vehicle', 'objId'=>$vehicle->ID, 'returnUrl'=>$currentUrl)); ?>
              <tr>
                <td>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $vehicle_url)), 'html5', 'UTF-8'); ?>>
                    <i class="icon-eye-open"></i>
                  </a>
                </td>
                <td>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $vehicle_url)), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars($vehicle->Descrizione,ENT_QUOTES,'UTF-8'); ?>
                  </a>
                </td>
                <td>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $vehicle_url)), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars($vehicle->Targa,ENT_QUOTES,'UTF-8'); ?>
                  </a>
                </td>
                <td>
                  <?php echo htmlspecialchars($vehicle->Nationality,ENT_QUOTES,'UTF-8'); ?>
                </td>
                <td>
                  <?php echo htmlspecialchars(t($vehicle->Classe),ENT_QUOTES,'UTF-8'); ?>
                </td>
                <td>
                  <?php echo htmlspecialchars(t($vehicle->category),ENT_QUOTES,'UTF-8'); ?>
                </td>
                <td>
                  <?php echo htmlspecialchars($vehicle->epoch,ENT_QUOTES,'UTF-8'); ?>
                </td>
                <td>
                  <?php if(user()->checkAccess('vehicle_management') && user()->checkAccess('vehicle_update')) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('vehicle/update', array('id'=>$vehicle->ID))))), 'html5', 'UTF-8'); ?>>
                      <i class="icon-pencil"></i>
                    </a>
                  <?php } ?>
                  <?php if(Yii::app()->user->checkAccess("plate_auth_delete")) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $delete_url), array('onclick', ('return confirm(\'' . (t('Are you sure you want to delete this item?')) . '\')'))), 'html5', 'UTF-8'); ?>>
                      <i class="icon-trash"></i>
                    </a>
                  <?php } ?>
                </td>
              </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
      <?php if (isset($vehicles->pagination)) { ?>
        <div class="pagination pagination-links-container">
          <?php $this->widget('bootstrap.widgets.TbPager', array('pages' => $vehicles->pagination)); ?>
        </div>
      <?php } ?>
    <?php } else { ?>
      <h4><?php echo htmlspecialchars(Yii::t("app", "No results"),ENT_QUOTES,'UTF-8'); ?></h4>
    <?php } ?>
  </div>
</div>
<?php if(true) { ?>
  <br />
  <div class="row">
    <div class="form-box">
      <?php $form = $this->beginWidget('bootstrap.widgets.TbActiveForm',      array('id'=>'vehicle-create-form','action' => Yii::app()->createUrl($this->route),'method' => 'POST',)); ?>
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'plateListId'), array('value', $plateListId)), 'html5', 'UTF-8'); ?> />
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'ownerId'), array('value', $ownerId)), 'html5', 'UTF-8'); ?> />
      <input type="hidden" name="step" value="2" />
      <input type="hidden" name="action" value="create" />
      <h3><?php echo htmlspecialchars(t("Create vehicle"),ENT_QUOTES,'UTF-8'); ?></h3>
      <h5><?php echo htmlspecialchars(Vehicle::model()->getAttributeLabel('Descrizione'),ENT_QUOTES,'UTF-8'); ?></h5>
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text'), array('name', 'v_description'), array('value', $paramDescription)), 'html5', 'UTF-8'); ?> />
      <?php echo htmlspecialchars(t("(for example: 'FIAT Panda')"),ENT_QUOTES,'UTF-8'); ?>
      <h5>
        <?php echo htmlspecialchars(Vehicle::model()->getAttributeLabel('Targa'),ENT_QUOTES,'UTF-8'); ?>
        <font color="red"><?php echo htmlspecialchars('*',ENT_QUOTES,'UTF-8'); ?></font>
      </h5>
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'touppercase'), array('type', 'text'), array('name', 'v_plate'), array('value', $what)), 'html5', 'UTF-8'); ?> />
      <h5>
        <?php echo htmlspecialchars(Vehicle::model()->getAttributeLabel('Nationality'),ENT_QUOTES,'UTF-8'); ?>
        <font color="red"><?php echo htmlspecialchars('*',ENT_QUOTES,'UTF-8'); ?></font>
      </h5>
      <?php echo CHtml::dropDownList('v_nationality', $paramNationality, array_merge(array('' => ''), CountryList::localized()), array('class'=>'span2  chzn-select', 'data-placeholder' => Yii::t('app', 'Country...')));; ?>
      <h5><?php echo htmlspecialchars(Vehicle::model()->getAttributeLabel('Classe'),ENT_QUOTES,'UTF-8'); ?></h5>
      <?php echo CHtml::dropDownList('v_class', $paramClass, array_merge(array('' => ''), VehicleTypes::localized()), array('class'=>'span2 chzn-select', 'data-placeholder' => Yii::t('app', 'Class...')));; ?>
      <h5><?php echo htmlspecialchars(Vehicle::model()->getAttributeLabel('source'),ENT_QUOTES,'UTF-8'); ?></h5>
      <?php if(count($vehicleSources)>0) { ?>
        <?php echo CHtml::dropDownList('v_source', $paramSource, $vehicleSources, array('class'=>'span2 chzn-select', 'data-placeholder' => Yii::t('app', 'Source...')));; ?>
      <?php } else { ?>
        <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text'), array('name', 'v_source'), array('value', $paramSource)), 'html5', 'UTF-8'); ?> />
      <?php } ?>
      <h5><?php echo htmlspecialchars(Vehicle::model()->getAttributeLabel('action'),ENT_QUOTES,'UTF-8'); ?></h5>
      <?php echo CHtml::textArea('v_action', $paramAction, array('class'=>'span2', 'maxlength' => '250'));; ?>
      <h5><?php echo htmlspecialchars(Vehicle::model()->getAttributeLabel('note'),ENT_QUOTES,'UTF-8'); ?></h5>
      <?php echo CHtml::textArea('v_note', $paramNote, array('class'=>'span2', 'maxlength' => '250'));; ?>
      <br />
      <br />
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'submit'), array('name', 'create'), array('value', (t('Create')))), 'html5', 'UTF-8'); ?> />
      <?php $this->endWidget(); ?>
    </div>
  </div>
<?php } ?>
<br />
<a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $goback_url)), 'html5', 'UTF-8'); ?>>
  <h4><?php echo htmlspecialchars(t('Go back'),ENT_QUOTES,'UTF-8'); ?></h4>
</a>
