<?php $countryList = CountryList::localized();; ?>
<h3>
  <?php echo htmlspecialchars(t('Vehicle', array(),'plateAutorizationDetails'),ENT_QUOTES,'UTF-8'); ?>
  <?php if(user()->checkAccess('plate_auth_view_ids')) { ?>
    <?php echo htmlspecialchars('#',ENT_QUOTES,'UTF-8'); ?>
    <?php echo htmlspecialchars($vehicle->ID,ENT_QUOTES,'UTF-8'); ?>
  <?php } ?>
  <?php if(user()->checkAccess('vehicle_management') && user()->checkAccess('vehicle_update')) { ?>
    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('vehicle/update', array('id'=>$vehicle->ID))))), 'html5', 'UTF-8'); ?>>
      <i class="icon-pencil"></i>
    </a>
  <?php } ?>
</h3>
<table class="table table-striped table-condensed">
  <thead>
    <tr>
      <th></th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>
        <?php echo htmlspecialchars($vehicle->getAttributeLabel('Targa'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td class="license-plate">
        <?php echo htmlspecialchars($vehicle->Targa,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars($vehicle->getAttributeLabel('Descrizione'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($vehicle->Descrizione,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars($vehicle->getAttributeLabel('Nationality'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php if($this->printCountryFlag($vehicle->Nationality)) { ?>
          <?php echo htmlspecialchars($countryList[$vehicle->Nationality],ENT_QUOTES,'UTF-8'); ?>
        <?php } ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars($vehicle->getAttributeLabel('Classe'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($vehicle->Classe,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars($vehicle->getAttributeLabel('type'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars(t($vehicle->type),ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars($vehicle->getAttributeLabel('category'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($vehicle->category,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars($vehicle->getAttributeLabel('source'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($vehicle->source,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars($vehicle->getAttributeLabel('action'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($vehicle->action,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars($vehicle->getAttributeLabel('note'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($vehicle->note,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
  </tbody>
</table>
