<?php $types = paramdeep('plateAuthorizations','types') ; ?>
<h3>
  <?php if($isBlack) { ?>
    <?php echo htmlspecialchars(t('Blacklist reporting'),ENT_QUOTES,'UTF-8'); ?>
  <?php } else     { ?>
    <?php echo htmlspecialchars(t('Plate authorization'),ENT_QUOTES,'UTF-8'); ?>
  <?php } ?>
  <?php echo htmlspecialchars('#',ENT_QUOTES,'UTF-8'); ?>
  <?php echo htmlspecialchars($plateAuthorization->ID  ,ENT_QUOTES,'UTF-8'); ?>
</h3>
<table class="table table-striped table-condensed">
  <thead>
    <tr>
      <th></th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->getAttributeLabel('Descrizione'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->Descrizione,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->getAttributeLabel('type'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars(array_key_exists($plateAuthorization->type, $types) ? $types[$plateAuthorization->type] : $plateAuthorization->type,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->getAttributeLabel('GateID'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo SystemInfoHelper::getPlateAuthGateCoolName($plateAuthorization->GateID,$plateAuthorization->GateID_type); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Time slot'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo SystemInfoHelper::getTimeScheduleCoolName($plateAuthorization->TimeID); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('List'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->plate_list->name ,ENT_QUOTES,'UTF-8'); ?>
        <?php echo htmlspecialchars(' - '   ,ENT_QUOTES,'UTF-8'); ?>
        <?php echo htmlspecialchars($plateAuthorization->plate_list->title,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php if($isBlack) { ?>
          <?php echo htmlspecialchars(t('Active reporting'),ENT_QUOTES,'UTF-8'); ?>
        <?php } else     { ?>
          <?php echo htmlspecialchars(t('Valid')        ,ENT_QUOTES,'UTF-8'); ?>
        <?php } ?>
      </td>
      <td>
        <?php if($plateAuthorization->enabled) { ?>
          <?php echo htmlspecialchars(t('Yes'),ENT_QUOTES,'UTF-8'); ?>
        <?php } else { ?>
          <?php echo htmlspecialchars(t('No'),ENT_QUOTES,'UTF-8'); ?>
        <?php } ?>
      </td>
    </tr>
    <?php if(!$isBlack)           { ?>
      <tr>
        <td>
          <?php echo htmlspecialchars(t('Request code'),ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php echo htmlspecialchars($plateAuthorization->request_code,ENT_QUOTES,'UTF-8'); ?>
        </td>
      </tr>
      <tr>
        <td>
          <?php echo htmlspecialchars(t('Authorization code'),ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php echo htmlspecialchars($plateAuthorization->authorization_code        ,ENT_QUOTES,'UTF-8'); ?>
        </td>
      </tr>
      <tr>
        <td>
          <?php echo htmlspecialchars(t('Path'),ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php echo htmlspecialchars($plateAuthorization->path  ,ENT_QUOTES,'UTF-8'); ?>
        </td>
      </tr>
      <tr>
        <td>
          <?php echo htmlspecialchars($plateAuthorization->getAttributeLabel('action'),ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php echo htmlspecialchars($plateAuthorization->action,ENT_QUOTES,'UTF-8'); ?>
        </td>
      </tr>
    <?php } ?>
    <tr>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->getAttributeLabel('Note'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->Note,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
  </tbody>
</table>
