<script type="text/javascript" src="../js/ajaxRenderer.js"></script>
<?php $countryList = CountryList::localized(); ?>
<?php $globalMode = false; ?>
<?php $liste = array(); ?>
<?php if($plateList == null) { ?>
  <?php $isBlack = false; ?>
  <?php $globalMode = true; ?>
  <?php $liste = PlateList::getCurrentUserLists(); ?>
  <?php $liste = array_remap($liste, function($k, $v){ return $v->code; });; ?>
<?php } else { ?>
  <?php $isBlack = $plateList->mode == PlateList::MODE_BLACK_LIST; ?>
  <?php $liste[$plateList->code] = $plateList; ?>
<?php } ?>
<?php if(!$globalMode) { ?>
  <?php if($isBlack) { ?>
    <?php $imgurl = $plateList->getImageUrl('/images/list_black.png'); ?>
  <?php } else { ?>
    <?php $imgurl = $plateList->getImageUrl('/images/list_white.png'); ?>
  <?php } ?>
<?php } ?>
<div id="plateauthsstatus-search-page">
  <?php $context = array('plateListId'=>$plateListId,'status'=>$status,'search'=>$search,'timeRange'=>$timeRange,'whitelistStatusDataProvider_page'=>$_REQUEST[whitelistStatusDataProvider_page],'sort'=>$sort); ?>
  <?php $currentUrl = Yii::app()->createAbsoluteUrl($this->route,$context); ?>
  <div class="page-header">
    <table width="100%">
      <tr>
        <td>
          <h2>
            <?php if(!$globalMode) { ?>
              <?php if($plateList->mode==PlateList::MODE_BLACK_LIST) { ?>
                <i class="icon-file-text"></i>
              <?php } else { ?>
                <i class="icon-file-text-alt"></i>
              <?php } ?>
            <?php } else { ?>
              <div class="icon-globe"></div>
            <?php } ?>
            <?php if($plateList->mode==PlateList::MODE_BLACK_LIST) { ?>
              <?php echo htmlspecialchars(t('Manage  blacklists'),ENT_QUOTES,'UTF-8'); ?>
            <?php } else { ?>
              <?php echo htmlspecialchars(t('Manage plate authorizations')  ,ENT_QUOTES,'UTF-8'); ?>
            <?php } ?>
          </h2>
          <h4>
            <?php if(!$globalMode) { ?>
              <?php echo htmlspecialchars($plateList->getListTitleComplete(),ENT_QUOTES,'UTF-8'); ?>
            <?php } else { ?>
              <?php echo htmlspecialchars(t("All lists"),ENT_QUOTES,'UTF-8'); ?>
            <?php } ?>
          </h4>
        </td>
        <td>
          <?php if(!empty($imgurl)) { ?>
            <img <?php echo MtHaml\Runtime::renderAttributes(array(array('src', $imgurl), array('width', '100'), array('align', 'right')), 'html5', 'UTF-8'); ?> />
          <?php } ?>
        </td>
      </tr>
    </table>
  </div>
  <div class="row" style="margin-bottom: 20px;">
    <div class="form-box">
      <?php $form = $this->beginWidget('bootstrap.widgets.TbActiveForm',      array('id'=>'plateauthstatus-search-form','action' => Yii::app()->createUrl($this->route),'method'=>'GET','htmlOptions'=>array('style'=>'margin-bottom: 0px;'),)); ?>
      <span>
        <fieldset>
          <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'plateListId'), array('value', $plateListId)), 'html5', 'UTF-8'); ?> />
          <b><?php echo htmlspecialchars(t('Search'),ENT_QUOTES,'UTF-8'); ?></b>
          <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text'), array('name', 'search'), array('value', $search), array('class', 'span2'), array('title', (t('You can use % as a wildcard')))), 'html5', 'UTF-8'); ?> />
          <b><?php echo htmlspecialchars(t('Time interval'),ENT_QUOTES,'UTF-8'); ?></b>
          <?php echo CHtml::dropDownList('timeRange', $timeRange, $timeRanges, array('style'=>'width: 120px;'));; ?>
          <b><?php echo htmlspecialchars(t('Status'),ENT_QUOTES,'UTF-8'); ?></b>
          <?php echo CHtml::dropDownList('status', $status, $statuses, array('style'=>'width: 120px;'));; ?>
          <b><?php echo htmlspecialchars(t('Sort'),ENT_QUOTES,'UTF-8'); ?></b>
          <?php echo CHtml::dropDownList('sort', $sort, $sortList, array('class'=>'span2'));; ?>
          <b><?php echo htmlspecialchars(t('#'),ENT_QUOTES,'UTF-8'); ?></b>
          <?php echo CHtml::dropDownList('pagination', $pagination, array(20=>20,50=>50,100=>100,200=>200), array('style'=>'width: 70px;'));; ?>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-small')), array('href', (url('plateAuthorization/whitelistStatus', array('plateListId'=>$plateListId)))), array('title', (t('Remove filters'))), array('style', 'margin-bottom: 10px;')), 'html5', 'UTF-8'); ?>>
            <i class="icon-remove"></i>
          </a>
          <button class="btn btn-small" type="submit" name="submit_search" autofocus="autofocus" style="margin-bottom: 10px;">
            <?php echo htmlspecialchars(t("Search"),ENT_QUOTES,'UTF-8'); ?>
          </button>
          <div class="btn-group pull-right">
            <a class="btn btn-small dropdown-toggle" data-toggle="dropdown" href="#">
              <?php echo htmlspecialchars(Yii::t("app", "Actions"),ENT_QUOTES,'UTF-8'); ?>
              <span class="caret"></span>
            </a>
            <ul class="dropdown-menu" id="multi-plate-actions">
              <?php if (user()->checkAccess('plate_auth_status_export')) { ?>
                <li>
                  <a href="#" id="multi-plate-action-export">
                    <?php echo htmlspecialchars(Yii::t("app", ("Export")),ENT_QUOTES,'UTF-8'); ?>
                  </a>
                </li>
              <?php } ?>
              <?php if (user()->checkAccess('plate_auth_renew')) { ?>
                <li>
                  <a href="#" id="multi-plate-action-renew">
                    <?php echo htmlspecialchars(Yii::t("app", ("Renew")),ENT_QUOTES,'UTF-8'); ?>
                  </a>
                </li>
              <?php } ?>
            </ul>
          </div>
          <?php if(user()->checkAccess('plate_auth_status_export')) { ?>
            <button class="pull-right btn btn-small" type="submit" id="submit_export" name="submit_export" style="margin-left: 5px;display: none;">
              <?php echo htmlspecialchars(t("Export"),ENT_QUOTES,'UTF-8'); ?>
            </button>
          <?php } ?>
          <?php if(user()->checkAccess('plate_auth_renew')) { ?>
            <button class="pull-right btn btn-small" type="submit" id="submit_renew_many" name="submit_renew_many" style="display: none;">
              <?php echo htmlspecialchars(t("Renew"),ENT_QUOTES,'UTF-8'); ?>
            </button>
          <?php } ?>
        </fieldset>
      </span>
      <?php $this->endWidget(); ?>
    </div>
  </div>
  <div id="plateauthstatusgrid" class="row">
    <div class="spinner">
      <div class="bounce1"></div>
      <div class="bounce2"></div>
      <div class="bounce3"></div>
    </div>
  </div>
</div>
