<div class="admin-menu-container span3">
  <div class="admin-menu-title">
    <?php echo htmlspecialchars(t("Actions"),ENT_QUOTES,'UTF-8'); ?>
  </div>
  <section>
    <span class="title">
      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('plateList/view', array('id' => $plateList->id)))), array('target', '_blank')), 'html5', 'UTF-8'); ?>>
        <?php echo htmlspecialchars(Yii::t("app", ("Details")) ,ENT_QUOTES,'UTF-8'); ?>
      </a>
    </span>
  </section>
  <?php if(Yii::app()->user->checkAccess("plate_list_management") && $plateList->editable && user()->checkAccess("edit_plate_list"))               { ?>
    <section>
      <span class="title">
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('plateList/update', array('id' => $plateList->id, 'from'=>$this->getAbsoluteUrl()))))), 'html5', 'UTF-8'); ?>>
          <?php echo htmlspecialchars(Yii::t("app", ("Update")),ENT_QUOTES,'UTF-8'); ?>
        </a>
      </span>
    </section>
  <?php } ?>
  <?php if(Yii::app()->user->checkAccess("plate_list_management") && $plateList->editable && Yii::app()->user->checkAccess("clear_plate_list"))        { ?>
    <section>
      <span class="title">
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('plateList/clearList', array('id' => $plateList->id)))), array('onclick', ('return confirm(\'' . (t('Are you sure you want to clear this list?')) . '\')'))), 'html5', 'UTF-8'); ?>>
          <?php echo htmlspecialchars(Yii::t("app", ("Clear")) ,ENT_QUOTES,'UTF-8'); ?>
        </a>
      </span>
    </section>
  <?php } ?>
  <?php if(Yii::app()->user->checkAccess("plate_list_management") && $plateList->editable && Yii::app()->user->checkAccess("delete_plate_list"))        { ?>
    <section>
      <span class="title">
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('plateList/delete', array('id' => $plateList->id)))), array('onclick', ('return confirm(\'' . (t('Are you sure you want to delete this list?')) . '\')'))), 'html5', 'UTF-8'); ?>>
          <?php echo htmlspecialchars(Yii::t("app", ("Delete"))        ,ENT_QUOTES,'UTF-8'); ?>
        </a>
      </span>
    </section>
  <?php } ?>
  <?php if($plateList->editable && $plateList->mode==PlateList::MODE_WHITE_LIST) { ?>
    <?php if($plateList->maxsize > 0 && user()->checkAccess('plate_auth_scheduler')) { ?>
      <section>
        <span class="title">
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'icon-table'), array('href', (url('plateAuthorization/scheduler',array('plateListId' => $plateList->id))))), 'html5', 'UTF-8'); ?>>
            <?php echo htmlspecialchars(t("Scheduler"),ENT_QUOTES,'UTF-8'); ?>
          </a>
        </span>
      </section>
    <?php } ?>
    <?php if(user()->checkAccess('plate_auth_insert') && user()->checkAccess('plate_auth_insert_wizard')) { ?>
      <section>
        <span class="title">
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('target', '_blank'), array('href', (Yii::app()->createUrl('plateAuthorization/whiteListWizard', array('plateListId' => $plateList->code))))), 'html5', 'UTF-8'); ?>>
            <?php echo htmlspecialchars(Yii::t("app", ("Add plate authorization wizard"))              ,ENT_QUOTES,'UTF-8'); ?>
          </a>
        </span>
      </section>
    <?php } ?>
    <?php if(user()->checkAccess('plate_auth_insert') && user()->checkAccess('plate_auth_insert_fast')) { ?>
      <section>
        <span class="title">
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('target', '_blank'), array('href', (Yii::app()->createUrl('plateAuthorization/newWhitelist', array('plateListId' => $plateList->id))))), 'html5', 'UTF-8'); ?>>
            <?php echo htmlspecialchars(Yii::t("app", ("Plate authorization fast insert")),ENT_QUOTES,'UTF-8'); ?>
          </a>
        </span>
      </section>
    <?php } ?>
    <?php if(user()->checkAccess('plate_auth_insert') && user()->checkAccess('plate_auth_insert_profile')) { ?>
      <?php foreach(PlateAuthInsertProfile::model()->findAll() as $paip) { ?>
        <?php if(user()->checkAccess("plate_auth_insert_profile_".$paip->id) && ($paip->list_code==-1 || $paip->list_code==$plateList->code)) { ?>
          <section>
            <span class="title">
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('plateAuthorization/NewPlateAuthProfile', array('plateListId' => $plateList->code, 'profileId'=>$paip->id)))), array('target', '_blank')), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars(Yii::t("app", $paip->description)                ,ENT_QUOTES,'UTF-8'); ?>
              </a>
            </span>
          </section>
        <?php } ?>
      <?php } ?>
    <?php } ?>
  <?php } ?>
  <?php if($plateList->mode==PlateList::MODE_WHITE_LIST && user()->checkAccess('plate_auth_status')) { ?>
    <section>
      <span class="title">
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('plateAuthorization/whitelistStatus', array('plateListId' => $plateList->code))))), 'html5', 'UTF-8'); ?>>
          <?php echo htmlspecialchars(Yii::t("app", ("Manage plate authorizations"))             ,ENT_QUOTES,'UTF-8'); ?>
        </a>
      </span>
    </section>
  <?php } ?>
  <?php if($plateList->editable && $plateList->mode==PlateList::MODE_BLACK_LIST) { ?>
    <section>
      <span class="title">
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('plateAuthorization/newBlacklist', array('plateListId' => $plateList->id))))), 'html5', 'UTF-8'); ?>>
          <?php echo htmlspecialchars(Yii::t("app", ("Add vehicle")),ENT_QUOTES,'UTF-8'); ?>
        </a>
      </span>
    </section>
  <?php } ?>
  <?php if(Yii::app()->user->checkAccess("plate_auth_diagnostic")) { ?>
    <section>
      <span class="title">
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('plateAuthorization/diagnostic', array('plateListId' => $plateList->code))))), 'html5', 'UTF-8'); ?>>
          <?php echo htmlspecialchars(t("Diagnostic"),ENT_QUOTES,'UTF-8'); ?>
        </a>
      </span>
    </section>
  <?php } ?>
  <?php if(user()->checkAccess("plate_auth_export_list_$code")) { ?>
    <section>
      <span class="title">
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('plateAuthorization/PlateAuthInfoExportList', array('code' => $plateList->code))))), 'html5', 'UTF-8'); ?>>
          <?php echo htmlspecialchars(t("Export"),ENT_QUOTES,'UTF-8'); ?>
        </a>
      </span>
    </section>
  <?php } ?>
</div>
