<script type="text/javascript" src="../js/blackListAjaxStats.js"></script>
<?php $isBlack = $plateList->mode == PlateList::MODE_BLACK_LIST; ?>
<?php if($isBlack) { ?>
  <?php $imgurl = $plateList->getImageUrl('/images/list_black.png'); ?>
<?php } else { ?>
  <?php $imgurl = $plateList->getImageUrl('/images/list_white.png'); ?>
<?php } ?>
<table width="100%">
  <tr>
    <td>
      <h2 <?php echo MtHaml\Runtime::renderAttributes(array(array('title', ($plateList->code))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars($plateList->name,ENT_QUOTES,'UTF-8'); ?></h2>
      <h3><?php echo htmlspecialchars($plateList->title,ENT_QUOTES,'UTF-8'); ?></h3>
      <?php if($isBlack) { ?>
        <h4><?php echo htmlspecialchars(t('Black list'),ENT_QUOTES,'UTF-8'); ?></h4>
      <?php } else { ?>
        <h4><?php echo htmlspecialchars(t('White list'),ENT_QUOTES,'UTF-8'); ?></h4>
      <?php } ?>
    </td>
    <td>
      <img <?php echo MtHaml\Runtime::renderAttributes(array(array('src', $imgurl), array('width', '200'), array('align', 'right')), 'html5', 'UTF-8'); ?> />
    </td>
  </tr>
  <tr>
    <td colspan="2">
      <hr />
    </td>
  </tr>
  <tr>
    <td colspan="2">
      <?php $this->renderPartial('plateListActions', array('plateList'=>$plateList)); ?>
    </td>
  </tr>
  <?php if(user()->checkAccess('stats_plate_list'))   { ?>
    <tr>
      <td colspan="2">
        <hr />
      </td>
    </tr>
    <tr>
      <td colspan="3">
        <h3><?php echo htmlspecialchars(t('Plate authorizations'),ENT_QUOTES,'UTF-8'); ?></h3>
        <ul>
          <?php foreach($stats as $name => $value) { ?>
            <li <?php echo MtHaml\Runtime::renderAttributes(array(array('id', (str_replace(" ","_",$name)))), 'html5', 'UTF-8'); ?>>
              <?php echo htmlspecialchars($name.': '.$value,ENT_QUOTES,'UTF-8'); ?>
            </li>
          <?php } ?>
        </ul>
      </td>
    </tr>
  <?php } ?>
</table>
