<?php $canEdit = $this->canEdit(); ?>
<div id="service-page">
  <?php $user = User::model()->findByPk(Yii::app()->user->id); ?>
  <div class="page-header">
    <h2><?php echo htmlspecialchars(Yii::t("app", "Tasks"),ENT_QUOTES,'UTF-8'); ?></h2>
  </div>
  <div id="services-summary" class="well">
    <?php $this->renderPartial("_servicesSummary", get_defined_vars()); ?>
  </div>
  <?php if($canEdit) { ?>
    <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('id', 'release-all'), array('data-confirm-text', (Yii::t('app', 'Confirm?')))), 'html5', 'UTF-8'); ?>>
      <?php echo htmlspecialchars(Yii::t("app", "Release all tasks"),ENT_QUOTES,'UTF-8'); ?>
    </button>
  <?php } ?>
  <?php $bfilter = false;; ?>
  <?php if(user()->checkAccess('service_can_filter_only_with_events')) { ?>
    <button class="btn">
      <a href="service?onlyWithEvents=1"><?php echo htmlspecialchars(t('Only with events'),ENT_QUOTES,'UTF-8'); ?></a>
    </button>
    <?php $bfilter = true;  ; ?>
  <?php } ?>
  <?php if(user()->checkAccess('service_can_filter_mine')) { ?>
    <button class="btn">
      <a href="service?mine=1"><?php echo htmlspecialchars(t('in charge to me')      ,ENT_QUOTES,'UTF-8'); ?></a>
    </button>
    <?php $bfilter = true;  ; ?>
  <?php } ?>
  <?php if(user()->checkAccess('service_can_filter_to_be_validated') && !paramdeep('report','byWorkPeriod')) { ?>
    <button class="btn">
      <a href="service?tobevalidated=1"><?php echo htmlspecialchars(t('to be validated'),ENT_QUOTES,'UTF-8'); ?></a>
    </button>
    <?php $bfilter = true; ; ?>
  <?php } ?>
  <?php if(user()->checkAccess('service_can_filter_validating_all')  && !paramdeep('report','byWorkPeriod')) { ?>
    <button class="btn">
      <a href="service?validating_all=1"><?php echo htmlspecialchars(t('validating'),ENT_QUOTES,'UTF-8'); ?></a>
    </button>
    <?php $bfilter = true;  ; ?>
  <?php } else if(user()->checkAccess('service_can_filter_validating')  && !paramdeep('report','byWorkPeriod')) { ?>
    <button class="btn">
      <a href="service?validating=1"><?php echo htmlspecialchars(t('validating'),ENT_QUOTES,'UTF-8'); ?></a>
    </button>
    <?php $bfilter = true; ; ?>
  <?php } ?>
  <?php if(user()->checkAccess('service_can_filter_exported_all') && !paramdeep('report','byWorkPeriod')) { ?>
    <button class="btn">
      <a href="service?exported_all=1"><?php echo htmlspecialchars(t('exported'),ENT_QUOTES,'UTF-8'); ?></a>
    </button>
    <?php $bfilter = true;        ; ?>
  <?php } else if(user()->checkAccess('service_can_filter_exported') && !paramdeep('report','byWorkPeriod')) { ?>
    <button class="btn">
      <a href="service?exported=1"><?php echo htmlspecialchars(t('exported')      ,ENT_QUOTES,'UTF-8'); ?></a>
    </button>
    <?php $bfilter = true;       ; ?>
  <?php } ?>
  <?php if($bfilter) { ?>
    <button class="btn">
      <a href="service?allServices"><?php echo htmlspecialchars(t('all')      ,ENT_QUOTES,'UTF-8'); ?></a>
    </button>
    <button class="btn">
      <a href="service"><?php echo htmlspecialchars(t('validable')      ,ENT_QUOTES,'UTF-8'); ?></a>
    </button>
  <?php } ?>
  <div id="services-partial" data-behavior="SlidePagination" style="padding-bottom: 40px;">
    <?php $this->renderPartial('_servicesTable', get_defined_vars()); ?>
  </div>
  <div id="modal-report-confirm" class="modal hide fade"></div>
</div>
