<?php $isBlack = $list->mode == PlateList::MODE_BLACK_LIST; ?>
<?php if($isBlack) { ?>
  <?php $imgurl = $list->getImageUrl('/images/list_black.png'); ?>
<?php } else { ?>
  <?php $imgurl = $list->getImageUrl('/images/list_white.png'); ?>
<?php } ?>
<?php $listType = $isBlacklist ? 'Blacklist' : 'Whitelist';; ?>
<?php if(isset($_POST['NewPlateAuthProfileForm'])) { ?>
  <?php /*var_dump_html($_POST['NewPlateAuthProfileForm'])*/; ?>
<?php } ?>
<div id="plate-authorization-page">
  <div class="page-header">
    <table width="100%">
      <tr>
        <td>
          <h2>
            <i class="icon-ok-circle"></i>
            <?php if(user()->checkAccess('plate_auth_confirmed') || $isBlack) { ?>
              <?php echo htmlspecialchars(Yii::t('app', "Add vehicle").': '.$list->getListTitle(),ENT_QUOTES,'UTF-8'); ?>
            <?php } else { ?>
              <?php echo htmlspecialchars(Yii::t('app', "Request to add vehicle").': '.$list->getListTitle(),ENT_QUOTES,'UTF-8'); ?>
            <?php } ?>
          </h2>
        </td>
        <td>
          <?php if(!empty($imgurl)) { ?>
            <img <?php echo MtHaml\Runtime::renderAttributes(array(array('src', $imgurl), array('width', '100'), array('align', 'right')), 'html5', 'UTF-8'); ?> />
          <?php } ?>
        </td>
      </tr>
    </table>
  </div>
  <?php echo $form->errorSummary($model); ?>
  <?php $columns = array(); ?>
  <?php foreach($fields as $field) { ?>
    <?php array_add_unique($columns, $field->column); ?>
  <?php } ?>
  <?php $columnSize = (int)(100/count($columns)); ?>
  <?php $comments = array(); ?>
  <form id="new-profile-plate-auth" method="POST">
    <input type="hidden" name="doit" value="doit" />
    <table style="width: 100%;">
      <tr>
        <?php foreach($columns as $columnIndex) { ?>
          <td <?php echo MtHaml\Runtime::renderAttributes(array(array('style', ('width: ' . $columnSize . '%; vertical-align: top;'))), 'html5', 'UTF-8'); ?>>
            <fieldset>
              <?php $currentGroup = null; ?>
              <?php foreach($fields as $field) { ?>
                <?php if(!isEmptyOrWhitespace($field->comment)) { ?>
                  <?php $comments[$field->name] = $field->comment; ?>
                <?php } ?>
                <?php if($field->column == $columnIndex) { ?>
                  <div class="row">
                    <?php if($field->visible) { ?>
                      <?php if($currentGroup != $field->group) { ?>
                        <?php $currentGroup = $field->group; ?>
                        <h4>
                          <?php echo htmlspecialchars(t(ucfirst($field->group)),ENT_QUOTES,'UTF-8'); ?>
                        </h4>
                      <?php } ?>
                      <?php if($field->type == PlateAuthInsertProfileFieldType::STRING) { ?>
                        <?php $this->renderPartial('insertProfile/_fieldText',get_defined_vars()); ?>
                      <?php } elseif($field->type == PlateAuthInsertProfileFieldType::MULTILINESTRING) { ?>
                        <?php $this->renderPartial('insertProfile/_fieldTextArea',get_defined_vars()); ?>
                      <?php } elseif($field->type == PlateAuthInsertProfileFieldType::CHECKBOX) { ?>
                        <?php $this->renderPartial('insertProfile/_fieldCheckbox',get_defined_vars()); ?>
                      <?php } elseif($field->type == PlateAuthInsertProfileFieldType::DROPDOWN) { ?>
                        <?php $this->renderPartial('insertProfile/_fieldDropdown',get_defined_vars()); ?>
                      <?php } elseif($field->type == PlateAuthInsertProfileFieldType::DATE) { ?>
                        <?php $this->renderPartial('insertProfile/_fieldDate',get_defined_vars()); ?>
                      <?php } elseif($field->type == PlateAuthInsertProfileFieldType::TIME) { ?>
                        <?php $this->renderPartial('insertProfile/_fieldTime',get_defined_vars()); ?>
                      <?php } elseif($field->type == PlateAuthInsertProfileFieldType::DATEBUTTONS) { ?>
                        <?php $this->renderPartial('insertProfile/_fieldDateButtons',get_defined_vars())              ; ?>
                      <?php } else { ?>
                        <?php echo htmlspecialchars(''              ,ENT_QUOTES,'UTF-8'); ?>
                      <?php } ?>
                    <?php } else { ?>
                      <?php $this->renderPartial('insertProfile/_fieldHidden',get_defined_vars()); ?>
                    <?php } ?>
                  </div>
                <?php } ?>
              <?php } ?>
            </fieldset>
          </td>
        <?php } ?>
      </tr>
    </table>
    <button <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'save-btn'), array('class', 'btn'), array('type', 'button'), array('data-confirm-text', (Yii::t('app', 'Confirm'))), array('data-form-action', (url('plateAuthorization/NewPlateAuthProfile', array('plateListId'=>$list->code,'profileId'=>$profile->id)))), array('data-target', '#new-profile-plate-auth')), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t('app', 'Create'),ENT_QUOTES,'UTF-8'); ?></button>
    <br />
    <br />
    <?php if(count($comments)>0) { ?>
      <div id="field-comments-box" style="border: 1px gray solid; border-radius: 5px; background-color: azure; padding: 5px 5px 5px 5px;">
        <h5><?php echo htmlspecialchars(t('Comments'),ENT_QUOTES,'UTF-8'); ?></h5>
        <div id="field-comments">
          <?php foreach($comments as $fieldName => $fieldComment)       { ?>
            <i style="position: relative; left: 10px; display: block;">
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ('#field_' . $fieldName))), 'html5', 'UTF-8'); ?>>
                <b>
                  <?php echo htmlspecialchars(t($fields[$fieldName]->label),ENT_QUOTES,'UTF-8'); ?>
                </b>
              </a>
              <?php echo htmlspecialchars(': ',ENT_QUOTES,'UTF-8'); ?>
              <?php echo htmlspecialchars($fieldComment,ENT_QUOTES,'UTF-8'); ?>
            </i>
          <?php } ?>
        </div>
      </div>
    <?php } ?>
  </form>
</div>
