<div class="page-header">
  <h2>
    <div class="icon-list"></div>
    <?php echo htmlspecialchars(t('Results'),ENT_QUOTES,'UTF-8'); ?>
  </h2>
</div>
<h4><?php echo htmlspecialchars($plateList->getListTitle(),ENT_QUOTES,'UTF-8'); ?></h4>
<br />
<?php $errorsPlates = array(); ?>
<table class="table table-condensed">
  <tr>
    <th><?php echo htmlspecialchars(t('Plate'),ENT_QUOTES,'UTF-8'); ?></th>
    <th><?php echo htmlspecialchars(t('Result'),ENT_QUOTES,'UTF-8'); ?></th>
    <th><?php echo htmlspecialchars(t('Message'),ENT_QUOTES,'UTF-8'); ?></th>
  </tr>
  <?php foreach($messages as $msg) { ?>
    <?php if(!$msg['result']) { ?>
      <?php $errorsPlates[] = $msg['plate']; ?>
    <?php } ?>
    <tr>
      <td>
        <?php echo htmlspecialchars($msg['plate'],ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <font <?php echo MtHaml\Runtime::renderAttributes(array(array('color', ($msg['color']))), 'html5', 'UTF-8'); ?>>
          <?php echo htmlspecialchars($msg['result']?t('Success'):t('Error'),ENT_QUOTES,'UTF-8'); ?>
        </font>
      </td>
      <td>
        <?php echo htmlspecialchars($msg['message'],ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
  <?php } ?>
</table>
<?php $errorsPlates = array_remove_dup($errorsPlates); ?>
<?php if(count($errorsPlates)>0) { ?>
  <?php $errorPlatesString = implode(' ',$errorsPlates); ?>
  <strong>
    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('plateAuthorization/newWhitelist', array('plateListId'=>$plateList->id, 'plate'=>$errorPlatesString))))), 'html5', 'UTF-8'); ?>>
      <?php echo htmlspecialchars(t('Some plates were not insert correctly, click here to try again.'),ENT_QUOTES,'UTF-8'); ?>
      <?php echo htmlspecialchars(" (".t('Plates').": $errorPlatesString)",ENT_QUOTES,'UTF-8'); ?>
    </a>
  </strong>
<?php } ?>
