<div class="page-header">
  <h2>
    <?php echo htmlspecialchars(t('PDF Repository'),ENT_QUOTES,'UTF-8'); ?>
  </h2>
</div>
<table class="table table-copndensed">
  <thead>
    <th>
      <?php echo htmlspecialchars(t('Filename'),ENT_QUOTES,'UTF-8'); ?>
    </th>
    <th>
      <?php echo htmlspecialchars(t('Epoch'),ENT_QUOTES,'UTF-8'); ?>
    </th>
    <th>
      <?php echo htmlspecialchars(t('Size').' (bytes)',ENT_QUOTES,'UTF-8'); ?>
    </th>
  </thead>
  <tbody>
    <?php $counter = 0; ?>
    <?php foreach($repository as $pdf_file) { ?>
      <?php if (!$pdf_file->isDot() && $pdf_file->isFile()) { ?>
        <?php $counter++; ?>
        <tr>
          <td>
            <?php $urlGet = url('pdfExport/GetFromRepository', array('userId'=>$user->id, 'pdfId'=>md5($pdf_file->getPathname()))); ?>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('target', '_blank'), array('href', $urlGet)), 'html5', 'UTF-8'); ?>>
              <?php echo htmlspecialchars($pdf_file->getFilename(),ENT_QUOTES,'UTF-8'); ?>
            </a>
          </td>
          <td>
            <?php echo htmlspecialchars(date(DateHelper::ISO9075_DATETIME, $pdf_file->getCTime()),ENT_QUOTES,'UTF-8'); ?>
          </td>
          <td>
            <?php echo htmlspecialchars($pdf_file->getSize(),ENT_QUOTES,'UTF-8'); ?>
          </td>
        </tr>
      <?php } ?>
    <?php } ?>
    <?php if($counter<=0) { ?>
      <tr>
        <td colspan="3">
          <center>
            <i>
              <?php echo htmlspecialchars(t('No results'),ENT_QUOTES,'UTF-8'); ?>
            </i>
          </center>
        </td>
      </tr>
    <?php } ?>
  </tbody>
</table>
