<?php $descriptionOptions = AlertHelper::getAlertTagNames();; ?>
<?php $types = $model->types; ; ?>
<?php $datePickerOption = array('dateFormat'=>'yy-mm-dd', 'changeMonth' => 'true', 'changeYear'=>'true',  'constrainInput' => 'false'); ; ?>
<div id="alerts-search-page">
  <div class="page-header">
    <h2><?php echo htmlspecialchars(t('Alerts'),ENT_QUOTES,'UTF-8'); ?></h2>
  </div>
  <div class="row">
    <div class="form-box">
      <?php $form = $this->beginWidget('bootstrap.widgets.TbActiveForm',      array('id'=>'alert-search-form','action' => Yii::app()->createUrl($this->route),)); ?>
      <div class="span11">
        <fieldset>
          <select <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'alert-description-filter'), array('class', ('selectpicker' . ' ' . 'span3')), array('multiple', 'multiple'), array('data-live-search', 'false'), array('title', (t('Select description...'))), array('name', 'AlertSearchForm[description][]')), 'html5', 'UTF-8'); ?>>
            <?php foreach($descriptionOptions as $theDescr) { ?>
              <?php if (isset($model->description) && in_array($theDescr['key'], $model->description)) { ?>
                <option <?php echo MtHaml\Runtime::renderAttributes(array(array('value', ($theDescr['key'])), array('selected', 'selected')), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars($theDescr['value'],ENT_QUOTES,'UTF-8'); ?>
                </option>
              <?php } else     { ?>
                <option <?php echo MtHaml\Runtime::renderAttributes(array(array('value', ($theDescr['key']))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars($theDescr['value'],ENT_QUOTES,'UTF-8'); ?>
                </option>
              <?php } ?>
            <?php } ?>
          </select>
          <select <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'gate-filter'), array('class', ('selectpicker' . ' ' . 'span3')), array('multiple', 'multiple'), array('data-live-search', 'false'), array('title', (t('Select gates...'))), array('name', 'AlertSearchForm[gates][]')), 'html5', 'UTF-8'); ?>>
            <?php foreach($gateList as $theGate) { ?>
              <?php if(in_array($theGate->Gate, $model->gates)) { ?>
                <option <?php echo MtHaml\Runtime::renderAttributes(array(array('value', ($theGate->Gate)), array('selected', 'selected')), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars($theGate->Descrizione,ENT_QUOTES,'UTF-8'); ?>
                </option>
              <?php } else     { ?>
                <option <?php echo MtHaml\Runtime::renderAttributes(array(array('value', ($theGate->Gate))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars($theGate->Descrizione,ENT_QUOTES,'UTF-8'); ?>
                </option>
              <?php } ?>
            <?php } ?>
          </select>
          <div class="btn-group span2" id="alert-filter-buttons" style="margin-bottom: 10px">
            <?php if(isset($types)  && in_array('alarm', $types)) { ?>
              <button id="alert-alarm-filter-button" class="filter-buttons btn active" type="button" data-filter="alarm">
                <i class="icon-exclamation-sign alarm alarm-icon"></i>
              </button>
            <?php } else     { ?>
              <button id="alert-alarm-filter-button" class="filter-buttons btn" type="button" data-filter="alarm">
                <i class="icon-exclamation-sign alarm alarm-icon"></i>
              </button>
            <?php } ?>
            <?php if(isset($types)  && in_array('warning', $types))     { ?>
              <button id="alert-warning-filter-button" class="filter-buttons btn active" type="button" data-filter="warning">
                <i class="icon-warning-sign alarm warning-icon"></i>
              </button>
            <?php } else     { ?>
              <button id="alert-warning-filter-button" class="filter-buttons btn" type="button" data-filter="warning">
                <i class="icon-warning-sign alarm warning-icon"></i>
              </button>
            <?php } ?>
            <?php if(isset($types)  && in_array('info', $types))     { ?>
              <button id="alert-info-filter-button" class="filter-buttons btn active" type="button" data-filter="info">
                <i class="icon-info-sign alarm info-icon"></i>
              </button>
            <?php } else     { ?>
              <button id="alert-info-filter-button" class="filter-buttons btn" type="button" data-filter="info">
                <i class="icon-info-sign alarm info-icon"></i>
              </button>
            <?php } ?>
            <?php if(isset($model->bookmark)  && $model->bookmark > 0)                  { ?>
              <button id="alert-info-filter-button" class="filter-buttons btn active" type="button" data-filter="bookmark">
                <i class="icon-bookmark"></i>
              </button>
            <?php } else                  { ?>
              <button id="alert-info-filter-button" class="filter-buttons btn" type="button" data-filter="bookmark">
                <i class="icon-bookmark"></i>
              </button>
            <?php } ?>
          </div>
          <div class="btn-group span2" id="alert-filter-status-buttons" style="margin-bottom: 10px">
            <?php if(isset($model->takenInChargeBy)  && $model->takenInChargeBy > 0) { ?>
              <button id="alert-takenincharge-filter-button" class="filter-buttons btn active" type="button" data-filter="takenincharge">
                <?php echo htmlspecialchars(t("Taken in charge"),ENT_QUOTES,'UTF-8'); ?>
              </button>
            <?php } else     { ?>
              <button id="alert-takenincharge-filter-button" class="filter-buttons btn" type="button" data-filter="takenincharge">
                <?php echo htmlspecialchars(t("Taken in charge"),ENT_QUOTES,'UTF-8'); ?>
              </button>
            <?php } ?>
            <?php if(isset($model->closedBy)  && $model->closedBy > 0) { ?>
              <button id="alert-closed-filter-button" class="filter-buttons btn active" type="button" data-filter="closed">
                <?php echo htmlspecialchars(t("Closed"),ENT_QUOTES,'UTF-8'); ?>
              </button>
            <?php } else     { ?>
              <button id="alert-closed-filter-button" class="filter-buttons btn" type="button" data-filter="closed">
                <?php echo htmlspecialchars(t("Closed")      ,ENT_QUOTES,'UTF-8'); ?>
              </button>
            <?php } ?>
          </div>
        </fieldset>
      </div>
      <div class="span11">
        <div id="alarm-filter-hidden-field-container"></div>
        <div id="alarm-status-filter-hidden-field-container">
          <input type="hidden" id="input-field-status-filter-takenincharge" name="AlertSearchForm[takenInChargeBy]" value="0" />
          <input type="hidden" id="input-field-status-filter-closed" name="AlertSearchForm[closedBy]" value="0" />
        </div>
        <div <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'date-time-range-search'), array('class', 'span6'), array('data-behavior', 'DateRangeInput'), array('data-date-range-start-target', ('#search-date-start')), array('data-date-range-end-target', ('#search-date-end'))), 'html5', 'UTF-8'); ?>>
          <div class="date-time-range-block span">
            <?php echo htmlspecialchars(t("From"),ENT_QUOTES,'UTF-8'); ?>
            <div id="search-date-start" class="input-append date datetime-picker">
              <input <?php echo MtHaml\Runtime::renderAttributes(array(array('data-format', (Yii::app()->params['datetimeselect_format'][Yii::app()->language]['view'])), array('type', 'text'), array('name', 'AlertSearchForm[startDateTime]'), array('value', ($model->startDateTime))), 'html5', 'UTF-8'); ?>>
                <span class="add-on">
                  <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
                </span>
              </input>
            </div>
          </div>
          <div class="date-time-range-block span">
            <?php echo htmlspecialchars(t("To")      ,ENT_QUOTES,'UTF-8'); ?>
            <div id="search-date-end" class="input-append date datetime-picker">
              <input <?php echo MtHaml\Runtime::renderAttributes(array(array('data-format', (Yii::app()->params['datetimeselect_format'][Yii::app()->language]['view'])), array('type', 'text'), array('name', 'AlertSearchForm[endDateTime]'), array('value', ($model->endDateTime))), 'html5', 'UTF-8'); ?>>
                <span class="add-on">
                  <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
                </span>
              </input>
            </div>
          </div>
        </div>
        <button id="search-for-alert" class="pull-right btn" type="submit">
          <?php echo htmlspecialchars(t("Filter"),ENT_QUOTES,'UTF-8'); ?>
        </button>
        <button id="search-for-alert" class="pull-right btn" type="submit" name="btn_export" value="ok">
          <?php echo htmlspecialchars(t("Export"),ENT_QUOTES,'UTF-8'); ?>
        </button>
      </div>
      <?php $this->endWidget(); ?>
    </div>
  </div>
  <div class="row">
    <div id="event-reporting-list" data-behavior="SlidePagination" data-page-form="#alert-search-form">
      <?php $this->renderPartial('_alertsTable', array('dataProvider' => $dataProvider)); ?>
    </div>
  </div>
</div>
