<?php $nationality = $event->custom_nationality; ?>
<?php if (isEmpty ( $nationality )) { ?>
  <?php if (paramdeep ( 'events', 'nationality', 'default' ) !== false) { ?>
    <?php $nationality = paramdeep ( 'events', 'nationality', 'default' );; ?>
  <?php } ?>
<?php } ?>
<?php $vehicleMatches = array(); ?>
<?php if($alert!=null) { ?>
  <?php $alertP = new AlertPresenter($alert); ?>
  <?php $vehicleMatches = $alertP->blacklistVehicleMatches; ?>
<?php } ?>
<?php $isWhitelist = false; ?>
<?php foreach ($event->gate->gateBehavior as $index => $gateBehavior) { ?>
  <?php if($gateBehavior->is_whitelist) { ?>
    <?php $isWhitelist = true; ?>
  <?php } ?>
<?php } ?>
<div id="alert-event-view">
  <div class="page-header">
    <div class="row clearfix">
      <div class="span8">
        <h2>
          <?php echo htmlspecialchars(t('Alert - Event detail'),ENT_QUOTES,'UTF-8'); ?>
        </h2>
      </div>
      <?php if(Yii::app()->user->checkAccess('export_pdf')) { ?>
        <div class="span4 pull-right text-right">
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('href', (Yii::app()->createAbsoluteUrl('alert/exportPdf', array('id' => $alert->id)))), array('target', ('_blank'))), 'html5', 'UTF-8'); ?>>
            <?php echo htmlspecialchars(t('Export'),ENT_QUOTES,'UTF-8'); ?>
          </a>
          <?php if(user()->checkAccess('alert_take_charge')) { ?>
            <?php if(isset($editEnable) && $editEnable) { ?>
              <button <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'save-alert'), array('class', 'btn'), array('type', 'submit'), array('data-confirm-text', (t('Confirm')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(t('Save & Close'),ENT_QUOTES,'UTF-8'); ?></button>
            <?php } else if(!$alert->isManaged()) { ?>
              <button <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'take-charge'), array('class', 'btn'), array('type', 'button'), array('data-confirm-text', (t('Confirm')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(t('Take Charge'),ENT_QUOTES,'UTF-8'); ?></button>
            <?php } ?>
          <?php } ?>
        </div>
      <?php } ?>
    </div>
  </div>
  <div class="row">
    <div class="span4">
      <div id="videos">
        <?php if(Yii::app()->user->checkAccess('media_view_video')) { ?>
          <?php foreach($event->videos as $video) { ?>
            <?php $this->renderVideo($video->url,370); ?>
          <?php } ?>
        <?php } ?>
      </div>
      <div id="etalage-container" data-behavior="MediaEtalage">
        <?php if(Yii::app()->user->checkAccess('media_view_photo')) { ?>
          <ul id="etalage">
            <?php foreach ($event->photos as $photo) { ?>
              <li>
                <?php if (!Yii::app()->user->checkAccess('edit_event_behaviors')) { ?>
                  <?php if(paramdeep('media','enableEnhancedMode')) { ?>
                    <?php $footer = $photo->getFooterRectangle(); ?>
                    <?php if (isset($footer)) { ?>
                      <div <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'footer'), array('data-rect-top', ($footer->topLeft->y)), array('data-rect-left', ($footer->topLeft->x)), array('data-rect-height', ($footer->height)), array('data-rect-width', ($footer->width)), array('data-image-height', ($photo->height)), array('data-image-width', ($photo->width))), 'html5', 'UTF-8'); ?>></div>
                    <?php } ?>
                    <?php $plate = $photo->getPlateRectangle(); ?>
                    <?php if (isset($plate)) { ?>
                      <div <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'plate'), array('data-rect-top', ($plate->topLeft->y)), array('data-rect-left', ($plate->topLeft->x)), array('data-rect-height', ($plate->height)), array('data-rect-width', ($plate->width)), array('data-image-height', ($photo->height)), array('data-image-width', ($photo->width)), array('data-plate-hide', '0')), 'html5', 'UTF-8'); ?>></div>
                    <?php } ?>
                    <?php $areas = $photo->getExtraAreas(); ?>
                    <?php if (isset($areas) && count($areas) > 0)     { ?>
                      <div class="extra-areas">
                        <?php foreach($areas as $areaType => $areaGroup) { ?>
                          <?php foreach($areaGroup as $area) { ?>
                            <div <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'extra-area'), array('data-type', $areaType), array('data-rect-top', ($area->topLeft->y)), array('data-rect-left', ($area->topLeft->x)), array('data-rect-height', ($area->height)), array('data-rect-width', ($area->width)), array('data-image-height', ($photo->height)), array('data-image-width', ($photo->width)), array('data-plate-hide', '0'), array('data-border-color', (ImageAreaHelper::getAreaColor($areaType)))), 'html5', 'UTF-8'); ?>></div>
                          <?php } ?>
                        <?php } ?>
                      </div>
                    <?php } ?>
                  <?php } ?>
                <?php } ?>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($photo->url))), 'html5', 'UTF-8'); ?>>
                  <img <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'etalage_source_image'), array('src', ($photo->url))), 'html5', 'UTF-8'); ?> />
                </a>
              </li>
            <?php } ?>
          </ul>
        <?php } ?>
      </div>
    </div>
    <div class="span8">
      <div <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'event-data'), array('data-behavior', ('nuclearifyAlertView')), array('data-alert-id', ($alert->id))), 'html5', 'UTF-8'); ?>>
        <div class="row">
          <?php $form = $this->beginWidget('bootstrap.widgets.TbActiveForm',array('type' => 'horizontal','action' => array('/alert/update/'.$alert->id),'htmlOptions' => array('id' => 'alert-form'),)); ?>
          <div class="span4">
            <fieldset>
              <?php if(isset($editEnable) && $editEnable) { ?>
                <?php $this->renderPartial('/alert/_eventDetails', array('event' => $event, 'form' => $form)); ?>
              <?php } else { ?>
                <?php $this->renderPartial('/alert/_eventDetails', array('event' => $event)); ?>
              <?php } ?>
            </fieldset>
          </div>
          <div class="span4">
            <div class="row">
              <fieldset>
                <?php if(isset($editEnable) && $editEnable) { ?>
                  <?php $this->renderPartial('/alert/_alertDetails', array('alert' => $alert, 'form' => $form)); ?>
                <?php } else { ?>
                  <?php $this->renderPartial('/alert/_alertDetails', array('alert' => $alert)); ?>
                <?php } ?>
                <?php if(sizeof($vehicleMatches) > 0) { ?>
                  <div class="blacklist-links">
                    <h4><?php echo htmlspecialchars(t("Blacklist matches"),ENT_QUOTES,'UTF-8'); ?></h4>
                    <div class="span">
                      <?php foreach($vehicleMatches as $vehicleMatch) { ?>
                        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($this->createUrl('PlateAuthorization/viewByVehicle', array('id'=>$vehicleMatch)))), array('target', '_blank')), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars("#{$vehicleMatch}",ENT_QUOTES,'UTF-8'); ?></a>
                        <br />
                      <?php } ?>
                    </div>
                  </div>
                <?php } ?>
              </fieldset>
            </div>
            <div class="row">
              <fieldset>
                <?php if( user()->checkAccess('show_event_violation_document')) { ?>
                  <?php $this->renderPartial('/alert/violationsList', array('event' => $event)); ?>
                <?php } ?>
              </fieldset>
            </div>
          </div>
        </div>
        <?php if($isWhitelist) { ?>
          <div class="row">
            <div class="span8">
              <?php $this->renderPartial("/event/_eventBehavior_WhiteList_SmartTips",$varsForWL); ?>
            </div>
          </div>
        <?php } ?>
        <?php $this->endWidget(); ?>
        <form <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'take-charge-form'), array('class', 'hidden'), array('action', ($this->createUrl('alert/takeCharge', array('id'=>$alert->id)))), array('method', 'POST')), 'html5', 'UTF-8'); ?>></form>
      </div>
    </div>
  </div>
  <div id="overlay">
    <div id="modal-image"></div>
  </div>
</div>
