<?php

/**
 * @property string IDLista
 * @property string IDPermesso
 * @property string IDAbbonamento
 * @property string IDVeicolo
 * @property string IDUtente
 * @property string Nome
 * @property string Lista
 * @property string Cognome
 * @property string Targa
 * @property string Nationality
 * @property string DataInizio
 * @property string DataFine
 * @property string Epoch
 * @property string Enabled
 * @property string ToBeConfirmed
 * @property string statusText
 * @property string statusColor
 * @property string expired
 * @property string aboutToExpire
 * @property string elapsed
 * @property string url_return
 * @property string url_renew
 * @property string url_revoke
 * @property string url_delete
 * @property string url_view
 * @property string url_confirm
 * @property string IDGate
 * @property string IDGate_type
 * @property string IDTime
 * @property string GateDescr
 * @property string TimeDescr
 * @property string DescrizionePermesso
 * @property string DescrizioneVeicolo
 * @property string DescrizionePeriodo
 * @property Gate GateObj
 * @property GateSet GateSetObj
 * @property GateGroup GateGroupObj
 * @property TimeSchedule TimeObj
 * @property string ModeLista
 * @property bool ListaIsBlack
 * @property bool ListaIsWhite
 * */
class SmartPlateAuth extends CArray {

    private $userRecord;
    private $abbonamentoRecord;
    private $vehicleRecord;
    private $gateRecord;
    private $timeTableRecord;
    private $plateListRecord;

    public function __construct(Array $properties = array()) {
        parent::__construct($properties);
        $this->userRecord = VehicleOwner::model()->findByPk(parent::__get('UserID'));
        $this->abbonamentoRecord = ValidityPeriod::model()->findByPk(parent::__get('AbbonamentoID'));
        $this->vehicleRecord = Vehicle::model()->findByPk(parent::__get('VehicleID'));
        $this->gateRecord = Gate::model()->findByPk(parent::__get('GateID'));
        $this->timeTableRecord = TimeSchedule::model()->findByPk(parent::__get('TimeID'));
        $this->plateListRecord = PlateList::model()->findByAttributes(array('code' => parent::__get('list_code')));
    }

    /**
     *
     * @param int $gate          
     * @param string $timestamp          
     * @return boolean
     */
    public function allowed($gate, $timestamp) {
        return ($this->Enabled && !$this->ToBeConfirmed && $this->containsDate($timestamp) && $this->containsGate($gate));
    }

    public function containsGate($gate) {
        if ($this->IDGate == - 1)
            return true;

        if ($gate instanceof Gate)
            $gate = $gate->Gate;

        if ($this->GateObj != null)
            if ($this->GateObj->Gate == $gate)
                return true;

        if ($this->GateSetObj != null)
            foreach ($this->GateSetObj->gates as $g)
                if ($g->Gate == $gate)
                    return true;

        if ($this->GateGroupObj != null)
            foreach ($this->GateGroupObj->gates as $g)
                if ($g->Gate == $gate)
                    return true;

        return false;
    }

    public function containsDateRange($date = null) {
        $date = DateHelper::ensureObject($date);
        return (date_in_range($this->DataInizio, $this->DataFine, $date));
    }

    public function containsDate($date = null) {
        $date = DateHelper::ensureObject($date);
        if ($this->containsDateRange($date))
            return $this->containsTimeSchedule($date);
        return false;
    }

    public function containsTimeSchedule($date = null) {
        $date = DateHelper::ensureObject($date);
        if ($this->IDTime == - 1)
            return true;
        /** @var TimeSchedule $timeObj */
        $timeObj = $this->TimeObj;
        if ($timeObj == null)
            return false;
        $slot = $timeObj->getBestSlotToday($date);

        if (is_null($slot))
            return false;

        return true;
    }

    public function __get($name) {
        /*
         * 'IDLista' => 'list_code'
          'IDPermesso' => 'ID'
          'IDAbbonamento' => 'AbbonamentoID'
          'IDVeicolo' => 'VehicleID'
          'IDUtente' => 'UserID'
          'Nome' => 'UserID->Nome'
          'Cognome' => 'UserID->Cognome'
          'Targa' => 'VehicleID->Targa'
          'Nationality' => 'VehicleID->Nationality'
          'DataInizio' => 'AbbonamentoID->DataInizio'
          'DataFine' => 'AbbonamentoID->DataFine'
          'Enabled ' => 'enabled '
          'ToBeConfirmed' => 'to_be_confirmed'
          'IDGate' => 'GateID'
          'IDGate_type' => 'GateID_type'
          'IDTime' => 'TimeID'
          'Epoch ' => 'epoch'
          'GateDescr' => 'GateID->Descrizione '
          'DescrizioneVeicolo' => 'VehicleID->Descrizione'
          'DescrizionePeriodo' => 'AbbonamentoID->Descrizione'
          'DescrizionePermesso' => 'Descrizione'
          'TimeDescr' => 'TimeID->Descrizione'
          'Lista' => 'list_code->name'
          'ModeLista' => 'list_code->mode'
         */
        $valueToReturn = null;
        switch ($name) {
            case "IDLista" :
                $valueToReturn = parent::__get("list_code");
                break;
            case "IDPermesso" :
                $valueToReturn = parent::__get("ID");
                break;
            case "IDAbbonamento" :
                $valueToReturn = parent::__get("AbbonamentoID");
                break;
            case "IDVeicolo" :
                $valueToReturn = parent::__get("VehicleID");
                break;
            case "IDUtente" :
                $valueToReturn = parent::__get("UserID");
                break;
            case "Nome" :
                if (isset($this->userRecord)) {
                    $valueToReturn = $this->userRecord->Nome;
                }
                break;
            case "Cognome" :
                if (isset($this->userRecord)) {
                    $valueToReturn = $this->userRecord->Cognome;
                }
                break;
            case "Targa" :
                if (isset($this->vehicleRecord)) {
                    $valueToReturn = $this->vehicleRecord->Targa;
                }
                break;
            case "Nationality" :
                if (isset($this->vehicleRecord)) {
                    $valueToReturn = $this->vehicleRecord->Nationality;
                }
                break;
            case "DataInizio" :
                if (isset($this->abbonamentoRecord)) {
                    $valueToReturn = date_format($this->abbonamentoRecord->DataInizio, 'Y-m-d H:i:s');
                }
                break;
            case "DataFine" :
                if (isset($this->abbonamentoRecord)) {
                    $valueToReturn = date_format($this->abbonamentoRecord->DataFine, 'Y-m-d H:i:s');
                }
                break;
            case "Enabled" :
                $valueToReturn = parent::__get("enabled");

                break;
            case "ToBeConfirmed" :
                $valueToReturn = parent::__get("to_be_confirmed");
                break;
            case "IDGate" :
                $valueToReturn = parent::__get("GateID");
                break;
            case "IDGate_type" :
                $valueToReturn = parent::__get("GateID_type");
                break;
            case "IDTime" :
                $valueToReturn = parent::__get("TimeID");
                break;
            case "Epoch" :
                $valueToReturn = parent::__get("epoch");
                break;
            case "GateDescr" :
                if (isset($this->gateRecord)) {
                    $valueToReturn = $this->gateRecord->Descrizione;
                }
                break;
            case "DescrizioneVeicolo" :
                if (isset($this->vehicleRecord)) {
                    $valueToReturn = $this->vehicleRecord->Descrizione;
                }
                break;
            case "DescrizionePeriodo" :
                if (isset($this->abbonamentoRecord)) {
                    $valueToReturn = $this->abbonamentoRecord->Descrizione;
                }
                break;
            case "DescrizionePermesso" :
                $valueToReturn = parent::__get("Descrizione");
                break;
            case "TimeDescr" :
                if (isset($this->timeTableRecord)) {
                    $valueToReturn = $this->timeTableRecord->Descrizione;
                }
                break;
            case "Lista" :
                if (isset($this->plateListRecord)) {
                    $valueToReturn = $this->plateListRecord->name;
                }
                break;
            case "ModeLista" :
                if (isset($this->plateListRecord)) {
                    $valueToReturn = $this->plateListRecord->mode;
                }
                break;
            default:
                $valueToReturn = parent::__get($name);
                break;
        }
        if (is_null($valueToReturn)) {
            $valueToReturn = parent::__get($name);
        }
        return $valueToReturn;
    }

//  
//              'wlt.list_code as IDLista',
//            'wlt.ID as IDPermesso',
//            'at.ID as IDAbbonamento',
//            'vt.ID as IDVeicolo',
//            'ut.ID as IDUtente',
//            'ut.Nome as Nome',
//            'ut.Cognome as Cognome',
//            'vt.Targa as Targa',
//            'vt.Nationality as Nationality',
//            'at.DataInizio as DataInizio',
//            'at.DataFine as DataFine',
//            'wlt.enabled as Enabled',
//            'wlt.to_be_confirmed as ToBeConfirmed',
//            'wlt.GateID as IDGate',
//            'wlt.GateID_type as IDGate_type',
//            'wlt.TimeID as IDTime',
//            'wlt.epoch as Epoch',
//            'gt.Descrizione as GateDescr',
//            'tt.Descrizione as TimeDescr',
//            'pl.name as Lista',
//            'pl.mode as ModeLista',
//            'wlt.Descrizione as DescrizionePermesso',
//            'vt.Descrizione as DescrizioneVeicolo',
//            'at.Descrizione as DescrizionePeriodo'
//  ID -> 370622
//Descrizione -> 100000 46 456 CD873SK
//Transito -> 
//VehicleID -> 370547
//GateID -> -1
//TimeID -> -1
//UserID -> 35
//AbbonamentoID -> 70
//Speciale -> 
//epoch -> 2015-06-08 11:21:18
//Category -> 
//Note -> 
//list_code -> 100000
//enabled -> 1
//to_be_confirmed -> 0
//insertid -> 16
//type -> P
//action -> 
//insert_id -> 
//GateID_type -> gate
//id_create_user -> 
//request_code -> 
//authorization_code -> 
//path -> 
//exported -> 0
}
