<?php

/**
 * This is the model class for table "bookmark".
 *
 * The followings are the available columns in table 'bookmark':
 * @property integer $id
 * @property integer $id_user
 * @property integer $id_reference
 * @property string $type
 * @property string $epoch
 */
class Bookmark extends ActiveRecord
{
	const TYPE_ALERT				      = 'event_reporting';
	const TYPE_VEHICLE_TRACE	    = 'vehicletrace';	
	const TYPE_EVENT	     				= 'event';	
	
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Bookmark the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'bookmark';
	}
	
	public function defaultScope()
	{
		return array(
				'condition'=>"id_user=".Yii::app()->user->id,
		);
	}
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_user, id_reference, epoch', 'required'),
			array('id_user, id_reference', 'numerical', 'integerOnly'=>true),
			array('type', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, id_user, id_reference, type, epoch', 'safe', 'on'=>'search'),
		);
	}
	public function behaviors()
	{
		return array('edatetimebehavior' => array('class' => 'ext.EDateTimeBehavior'));
	}
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function myAttributeLabels()
	{
		return array(
			'id' => 'ID',
			'id_user' => 'Id User',
			'id_reference' => 'Id Reference',
			'type' => 'Type',
			'epoch' => 'Epoch',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('id_user',$this->id_user);
		$criteria->compare('id_reference',$this->id_reference);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('epoch',$this->epoch,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	public function addBookmark($operator, $id_reference, $type)
	{
		$this->id_user = $operator->id;
		$timeNow = new DateTime();
		$this->epoch = $timeNow;
		$this->id_reference = $id_reference;
		$this->type = $type;
	
		return $this->insert();
	}
	
	public function byIdReference($id_reference)
	{
		$this->getDbCriteria()->mergeWith(
				array(
						'condition' => 'id_reference = :idreference',
						'params' => array(':idreference' => $id_reference),
				)
		);
		return $this;
	}
	
	public function byType($type)
	{
		$this->getDbCriteria()->mergeWith(
				array(
						'condition' => 'type = :type',
						'params' => array(':type' => $type),
				)
		);
		
		return $this;
	}
	public function byUser($user)
	{
		$this->getDbCriteria()->mergeWith(
				array(
						'condition' => 'id_user = :iduser',
						'params' => array(':iduser' => $user->id),
				)
		);
	
		return $this;
	}

	public function deleteRecords()
	{
		$criteria = $this->getDbCriteria();
		
		$this->deleteAll($criteria);
	
		return $this;
	}
	
	
	
}