-- MySQL dump 10.13  Distrib 5.5.29, for debian-linux-gnu (x86_64)
--
-- Host: 127.0.0.1    Database: eventserverdb
-- ------------------------------------------------------
-- Server version	5.5.29-0ubuntu0.12.10.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `abbonamentotable`
--

DROP TABLE IF EXISTS `abbonamentotable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `abbonamentotable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `Descrizione` char(250) DEFAULT NULL,
  `Tipo` char(250) DEFAULT NULL,
  `DataInizio` datetime DEFAULT NULL,
  `DataFine` datetime DEFAULT NULL,
  `Abilitato` bigint(20) DEFAULT NULL,
  `Credito` bigint(20) DEFAULT NULL,
  `Autorizzazione` bigint(20) DEFAULT NULL,
  `UserID` bigint(20) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  `Codice` char(250) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `UserID` (`UserID`),
  KEY `index_userid` (`UserID`),
  KEY `index_abbdescr` (`Descrizione`),
  KEY `index_abbtype` (`Tipo`),
  KEY `index_abbcode` (`Codice`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activitytable`
--

DROP TABLE IF EXISTS `activitytable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activitytable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `epoch` datetime DEFAULT NULL,
  `Code` char(250) DEFAULT NULL,
  `Description` char(250) DEFAULT NULL,
  `TableName` char(250) DEFAULT NULL,
  `RecordID` bigint(20) DEFAULT NULL,
  `Type` char(250) DEFAULT NULL,
  `Priority` bigint(20) DEFAULT NULL,
  `Managed` bigint(20) DEFAULT NULL,
  `ManagedBy` char(250) DEFAULT NULL,
  `ManagedEpoch` datetime DEFAULT NULL,
  `EventUUID` char(250) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_order_epoch` (`epoch`),
  KEY `index_order_code` (`Code`),
  KEY `index_order_priority` (`Priority`),
  KEY `index_order_managed` (`Managed`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `alarmtable`
--

DROP TABLE IF EXISTS `alarmtable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `alarmtable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `AlarmID` char(250) DEFAULT NULL,
  `AlarmDescription` char(250) DEFAULT NULL,
  `LinkedTable` char(250) DEFAULT NULL,
  `LinkedID` bigint(20) DEFAULT NULL,
  `LinkedPage` char(250) DEFAULT NULL,
  `Source` char(250) DEFAULT NULL,
  `ManagedBy` char(250) DEFAULT NULL,
  `Type` char(250) DEFAULT NULL,
  `Priority` bigint(20) DEFAULT NULL,
  `UserID` bigint(20) DEFAULT NULL,
  `TicketID` bigint(20) DEFAULT NULL,
  `Ticket` char(250) DEFAULT NULL,
  `AreaID` bigint(20) DEFAULT NULL,
  `PositionID` bigint(20) DEFAULT NULL,
  `Gate` bigint(20) DEFAULT NULL,
  `TransitTime` datetime DEFAULT NULL,
  `Plate` char(250) DEFAULT NULL,
  `Nationality` char(250) DEFAULT NULL,
  `Image` mediumblob,
  `ImageLength` bigint(20) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_order_epoch` (`epoch`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `appinfotable`
--

DROP TABLE IF EXISTS `appinfotable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `appinfotable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `ApplicationID` bigint(20) DEFAULT NULL,
  `ApplicationName` char(250) DEFAULT NULL,
  `ApplicationVer` char(250) DEFAULT NULL,
  `ApplicationIP` char(250) DEFAULT NULL,
  `TheUser` char(250) DEFAULT NULL,
  `ExpiryDate` datetime DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `areatable`
--

DROP TABLE IF EXISTS `areatable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `areatable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `Descrizione` char(250) DEFAULT NULL,
  `IDArea` bigint(20) DEFAULT NULL,
  `TempoTransito` bigint(20) DEFAULT NULL,
  `PostiTotali` bigint(20) DEFAULT NULL,
  `PostiOffSet` bigint(20) DEFAULT NULL,
  `PostiOccupati` bigint(20) DEFAULT NULL,
  `field_prova` bigint(20) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_order_AreaID` (`IDArea`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `authassignment`
--

DROP TABLE IF EXISTS `authassignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `authassignment` (
  `itemname` varchar(64) NOT NULL,
  `userid` varchar(64) NOT NULL,
  `bizrule` text,
  `data` text,
  PRIMARY KEY (`itemname`,`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `authitem`
--

DROP TABLE IF EXISTS `authitem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `authitem` (
  `name` varchar(64) NOT NULL,
  `type` int(11) NOT NULL,
  `description` text,
  `bizrule` text,
  `data` text,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `authitemchild`
--

DROP TABLE IF EXISTS `authitemchild`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `authitemchild` (
  `parent` varchar(64) NOT NULL,
  `child` varchar(64) NOT NULL,
  PRIMARY KEY (`parent`,`child`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `backuptable`
--

DROP TABLE IF EXISTS `backuptable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `backuptable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `UserID` bigint(20) DEFAULT NULL,
  `EventType` char(250) DEFAULT NULL,
  `EventMode` char(250) DEFAULT NULL,
  `ModifiedBy` char(250) DEFAULT NULL,
  `EventValid` char(250) DEFAULT NULL,
  `ValidatedBy` char(250) DEFAULT NULL,
  `ValidationTime` datetime DEFAULT NULL,
  `Protocol` char(250) DEFAULT NULL,
  `NextID` bigint(20) DEFAULT NULL,
  `PreviousID` bigint(20) DEFAULT NULL,
  `TicketID` bigint(20) DEFAULT NULL,
  `Ticket` char(250) DEFAULT NULL,
  `AreaID` bigint(20) DEFAULT NULL,
  `PositionID` bigint(20) DEFAULT NULL,
  `Direction` bigint(20) DEFAULT NULL,
  `Speed` double DEFAULT NULL,
  `Classe` char(250) DEFAULT NULL,
  `Height` double DEFAULT NULL,
  `Width` double DEFAULT NULL,
  `Length` double DEFAULT NULL,
  `LaneID` bigint(20) DEFAULT NULL,
  `IsBoxComputed` bigint(20) DEFAULT NULL,
  `Gate` bigint(20) DEFAULT NULL,
  `StartTime` datetime DEFAULT NULL,
  `EndTime` datetime DEFAULT NULL,
  `Plate` char(250) DEFAULT NULL,
  `ExtPlate` char(250) DEFAULT NULL,
  `Nationality` char(250) DEFAULT NULL,
  `NetworkID` bigint(20) DEFAULT NULL,
  `Image` mediumblob,
  `ImageLength` bigint(20) DEFAULT NULL,
  `Comments` char(250) DEFAULT NULL,
  `ExtraData` mediumblob,
  `ExtraDataLength` bigint(20) DEFAULT NULL,
  `Signature` mediumblob,
  `SignatureLength` bigint(20) DEFAULT NULL,
  `UUID` char(250) DEFAULT NULL,
  `ExtraInfoID` bigint(20) DEFAULT NULL,
  `MatchMeasure` double DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  `GateDescription` char(250) DEFAULT NULL,
  `TransitComments` char(250) DEFAULT NULL,
  `GateType` char(10) DEFAULT NULL,
  `Kemler` char(250) DEFAULT NULL,
  `PlateCheck` bigint(20) DEFAULT NULL,
  `BlobFileName` char(250) DEFAULT NULL,
  `Color` char(250) DEFAULT NULL,
  `data_check` tinyint(4) DEFAULT NULL,
  `id_run` bigint(20) DEFAULT NULL,
  `id_vehicle_color` bigint(20) DEFAULT NULL,
  `data_check_time` datetime DEFAULT NULL,
  `id_data_check_user` bigint(20) DEFAULT NULL,
  `id_validate_user` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_order_starttime` (`StartTime`),
  KEY `index_order_plate` (`Plate`),
  KEY `index_order_protocol` (`Protocol`),
  KEY `index_order_validatedby` (`ValidatedBy`),
  KEY `index_order_gate` (`Gate`),
  KEY `index_order_uuid` (`UUID`),
  KEY `index_order_epoch` (`epoch`),
  KEY `index_order_ticketid` (`TicketID`),
  KEY `index_order_areaid` (`AreaID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `behavior`
--

DROP TABLE IF EXISTS `behavior`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `behavior` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` char(250) DEFAULT NULL,
  `description` text,
  `tag` char(250) DEFAULT NULL,
  `confirmable` tinyint(4) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `bfrmsgtable`
--

DROP TABLE IF EXISTS `bfrmsgtable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bfrmsgtable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `PHNum` bigint(20) DEFAULT NULL,
  `EvtTCCType` int(11) DEFAULT NULL,
  `NewTicTime` int(11) DEFAULT NULL,
  `TicSerNum` int(11) DEFAULT NULL,
  `EvtISOString` char(250) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_order_epoch` (`epoch`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `blacklistevents`
--

DROP TABLE IF EXISTS `blacklistevents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blacklistevents` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `UserID` bigint(20) DEFAULT NULL,
  `EventType` char(250) DEFAULT NULL,
  `EventMode` char(250) DEFAULT NULL,
  `ModifiedBy` char(250) DEFAULT NULL,
  `EventValid` char(250) DEFAULT NULL,
  `ValidatedBy` char(250) DEFAULT NULL,
  `ValidationTime` datetime DEFAULT NULL,
  `Protocol` char(250) DEFAULT NULL,
  `NextID` bigint(20) DEFAULT NULL,
  `PreviousID` bigint(20) DEFAULT NULL,
  `TicketID` bigint(20) DEFAULT NULL,
  `Ticket` char(250) DEFAULT NULL,
  `AreaID` bigint(20) DEFAULT NULL,
  `PositionID` bigint(20) DEFAULT NULL,
  `Direction` bigint(20) DEFAULT NULL,
  `Speed` double DEFAULT NULL,
  `Classe` char(250) DEFAULT NULL,
  `Height` double DEFAULT NULL,
  `Width` double DEFAULT NULL,
  `Length` double DEFAULT NULL,
  `LaneID` bigint(20) DEFAULT NULL,
  `IsBoxComputed` bigint(20) DEFAULT NULL,
  `Gate` bigint(20) DEFAULT NULL,
  `StartTime` datetime DEFAULT NULL,
  `EndTime` datetime DEFAULT NULL,
  `Plate` char(250) DEFAULT NULL,
  `ExtPlate` char(250) DEFAULT NULL,
  `Nationality` char(250) DEFAULT NULL,
  `NetworkID` bigint(20) DEFAULT NULL,
  `Image` mediumblob,
  `ImageLength` bigint(20) DEFAULT NULL,
  `Comments` char(250) DEFAULT NULL,
  `ExtraData` mediumblob,
  `ExtraDataLength` bigint(20) DEFAULT NULL,
  `Signature` mediumblob,
  `SignatureLength` bigint(20) DEFAULT NULL,
  `UUID` char(250) DEFAULT NULL,
  `ExtraInfoID` bigint(20) DEFAULT NULL,
  `MatchMeasure` double DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  `GateDescription` char(250) DEFAULT NULL,
  `TransitComments` char(250) DEFAULT NULL,
  `GateType` char(10) DEFAULT NULL,
  `Kemler` char(250) DEFAULT NULL,
  `PlateCheck` bigint(20) DEFAULT NULL,
  `BlobFileName` char(250) DEFAULT NULL,
  `Color` char(250) DEFAULT NULL,
  `data_check` tinyint(4) DEFAULT NULL,
  `id_run` bigint(20) DEFAULT NULL,
  `id_vehicle_color` bigint(20) DEFAULT NULL,
  `data_check_time` datetime DEFAULT NULL,
  `id_data_check_user` bigint(20) DEFAULT NULL,
  `id_validate_user` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_order_starttime` (`StartTime`),
  KEY `index_order_plate` (`Plate`),
  KEY `index_order_protocol` (`Protocol`),
  KEY `index_order_validatedby` (`ValidatedBy`),
  KEY `index_order_gate` (`Gate`),
  KEY `index_order_uuid` (`UUID`),
  KEY `index_order_epoch` (`epoch`),
  KEY `index_order_ticketid` (`TicketID`),
  KEY `index_order_areaid` (`AreaID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `configtable`
--

DROP TABLE IF EXISTS `configtable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `configtable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `Status` char(20) DEFAULT NULL,
  `Savingdate` datetime DEFAULT NULL,
  `Operator` char(100) DEFAULT NULL,
  `LastUpdate` datetime DEFAULT NULL,
  `DataRequest` datetime DEFAULT NULL,
  `DataReceived` datetime DEFAULT NULL,
  `DataApplied` datetime DEFAULT NULL,
  `DataNotifyApplied` datetime DEFAULT NULL,
  `DataNotifyReceived` datetime DEFAULT NULL,
  `ApplyDate` datetime DEFAULT NULL,
  `GateID` bigint(20) DEFAULT NULL,
  `FromServerToApp` tinyint(4) DEFAULT NULL,
  `UUID` char(50) DEFAULT NULL,
  `Version` bigint(20) DEFAULT NULL,
  `ConfigData` longblob,
  `ConfigDataLength` bigint(20) DEFAULT NULL,
  `Comment` char(250) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `events_behavior`
--

DROP TABLE IF EXISTS `events_behavior`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `events_behavior` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `id_event` bigint(20) DEFAULT NULL,
  `id_behavior` bigint(20) DEFAULT NULL,
  `validation_result` char(250) DEFAULT NULL,
  `comment` char(250) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  `violation_code` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eventtransfertable`
--

DROP TABLE IF EXISTS `eventtransfertable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `eventtransfertable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `TableName` char(250) DEFAULT NULL,
  `EventID` char(250) DEFAULT NULL,
  `EventUUID` char(250) DEFAULT NULL,
  `Plate` char(250) DEFAULT NULL,
  `EventType` char(250) DEFAULT NULL,
  `EventDateTime` datetime DEFAULT NULL,
  `EventEpoch` datetime DEFAULT NULL,
  `TransferDateTime` datetime DEFAULT NULL,
  `Status` double DEFAULT NULL,
  `ReferenceSystem` char(250) DEFAULT NULL,
  `ErrorCode` double DEFAULT NULL,
  `ErrorDescription` char(250) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gate_behavior`
--

DROP TABLE IF EXISTS `gate_behavior`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gate_behavior` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `id_gate` bigint(20) DEFAULT NULL,
  `id_behavior` bigint(20) DEFAULT NULL,
  `validate` tinyint(4) DEFAULT NULL,
  `generate_alarm` tinyint(4) DEFAULT NULL,
  `to_ignore` tinyint(4) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gate_group`
--

DROP TABLE IF EXISTS `gate_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gate_group` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` char(250) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gatedirectiontable`
--

DROP TABLE IF EXISTS `gatedirectiontable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gatedirectiontable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `Descrizione` char(250) DEFAULT NULL,
  `Type` char(250) DEFAULT NULL,
  `Gate` bigint(20) DEFAULT NULL,
  `Direction` bigint(20) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_gate` (`Gate`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gateordertable`
--

DROP TABLE IF EXISTS `gateordertable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gateordertable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `Gate` bigint(20) DEFAULT NULL,
  `PrevGate` bigint(20) DEFAULT NULL,
  `MinTimeElapsed` char(250) DEFAULT NULL,
  `MaxTimeElapsed` char(250) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gatetable`
--

DROP TABLE IF EXISTS `gatetable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gatetable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `Descrizione` char(250) DEFAULT NULL,
  `Matricola` char(250) DEFAULT NULL,
  `ValidationMaxDelay` bigint(20) DEFAULT NULL,
  `Type` char(250) DEFAULT NULL,
  `Gate` bigint(20) DEFAULT NULL,
  `Enable` bigint(20) DEFAULT NULL,
  `IP` char(16) DEFAULT NULL,
  `Code` char(250) DEFAULT NULL,
  `LinkedGate` bigint(20) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  `AreaSourceID` bigint(20) DEFAULT NULL,
  `AreaDestinationID` bigint(20) DEFAULT NULL,
  `Status` char(250) DEFAULT NULL,
  `LastLifeSignal` datetime DEFAULT NULL,
  `Homologation` char(250) DEFAULT NULL,
  `LastEventID` bigint(20) DEFAULT NULL,
  `LifeSignalTimeOut` bigint(20) DEFAULT NULL,
  `LastEventTime` datetime DEFAULT NULL,
  `GateType` char(10) DEFAULT NULL,
  `id_group` bigint(20) DEFAULT NULL,
  `speed_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_gate` (`Gate`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `interestingevents`
--

DROP TABLE IF EXISTS `interestingevents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `interestingevents` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `UserID` bigint(20) DEFAULT NULL,
  `EventType` char(250) DEFAULT NULL,
  `EventMode` char(250) DEFAULT NULL,
  `ModifiedBy` char(250) DEFAULT NULL,
  `EventValid` char(250) DEFAULT NULL,
  `ValidatedBy` char(250) DEFAULT NULL,
  `ValidationTime` datetime DEFAULT NULL,
  `Protocol` char(250) DEFAULT NULL,
  `NextID` bigint(20) DEFAULT NULL,
  `PreviousID` bigint(20) DEFAULT NULL,
  `TicketID` bigint(20) DEFAULT NULL,
  `Ticket` char(250) DEFAULT NULL,
  `AreaID` bigint(20) DEFAULT NULL,
  `PositionID` bigint(20) DEFAULT NULL,
  `Direction` bigint(20) DEFAULT NULL,
  `Speed` double DEFAULT NULL,
  `Classe` char(250) DEFAULT NULL,
  `Height` double DEFAULT NULL,
  `Width` double DEFAULT NULL,
  `Length` double DEFAULT NULL,
  `LaneID` bigint(20) DEFAULT NULL,
  `IsBoxComputed` bigint(20) DEFAULT NULL,
  `Gate` bigint(20) DEFAULT NULL,
  `StartTime` datetime DEFAULT NULL,
  `EndTime` datetime DEFAULT NULL,
  `Plate` char(250) DEFAULT NULL,
  `ExtPlate` char(250) DEFAULT NULL,
  `Nationality` char(250) DEFAULT NULL,
  `NetworkID` bigint(20) DEFAULT NULL,
  `Image` mediumblob,
  `ImageLength` bigint(20) DEFAULT NULL,
  `Comments` char(250) DEFAULT NULL,
  `ExtraData` mediumblob,
  `ExtraDataLength` bigint(20) DEFAULT NULL,
  `Signature` mediumblob,
  `SignatureLength` bigint(20) DEFAULT NULL,
  `UUID` char(250) DEFAULT NULL,
  `ExtraInfoID` bigint(20) DEFAULT NULL,
  `MatchMeasure` double DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  `GateDescription` char(250) DEFAULT NULL,
  `TransitComments` char(250) DEFAULT NULL,
  `GateType` char(10) DEFAULT NULL,
  `Kemler` char(250) DEFAULT NULL,
  `PlateCheck` bigint(20) DEFAULT NULL,
  `BlobFileName` char(250) DEFAULT NULL,
  `Color` char(250) DEFAULT NULL,
  `data_check` tinyint(4) DEFAULT NULL,
  `id_run` bigint(20) DEFAULT NULL,
  `id_vehicle_color` bigint(20) DEFAULT NULL,
  `data_check_time` datetime DEFAULT NULL,
  `id_data_check_user` bigint(20) DEFAULT NULL,
  `id_validate_user` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_order_starttime` (`StartTime`),
  KEY `index_order_plate` (`Plate`),
  KEY `index_order_protocol` (`Protocol`),
  KEY `index_order_validatedby` (`ValidatedBy`),
  KEY `index_order_gate` (`Gate`),
  KEY `index_order_uuid` (`UUID`),
  KEY `index_order_epoch` (`epoch`),
  KEY `index_order_ticketid` (`TicketID`),
  KEY `index_order_areaid` (`AreaID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `platetable`
--

DROP TABLE IF EXISTS `platetable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `platetable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `Plate` char(250) DEFAULT NULL,
  `ExtPlate` char(250) DEFAULT NULL,
  `Image` mediumblob,
  `ImageLength` bigint(20) DEFAULT NULL,
  `StartTime` datetime DEFAULT NULL,
  `EndTime` datetime DEFAULT NULL,
  `Gate` bigint(20) DEFAULT NULL,
  `DirectionID` bigint(20) DEFAULT NULL,
  `DirectionRecog` bigint(20) DEFAULT NULL,
  `DirectionMatch` bigint(20) DEFAULT NULL,
  `ChannelID` bigint(20) DEFAULT NULL,
  `ID1` bigint(20) DEFAULT NULL,
  `ID2` bigint(20) DEFAULT NULL,
  `ID3` bigint(20) DEFAULT NULL,
  `Speed` double DEFAULT NULL,
  `Classe` char(250) DEFAULT NULL,
  `TicketID` char(250) DEFAULT NULL,
  `AreaID` bigint(20) DEFAULT NULL,
  `Nationality` char(250) DEFAULT NULL,
  `NetworkID` bigint(20) DEFAULT NULL,
  `Comments` char(250) DEFAULT NULL,
  `ExtraData` mediumblob,
  `ExtraDataLength` bigint(20) DEFAULT NULL,
  `Signature` blob,
  `SignatureLength` bigint(20) DEFAULT NULL,
  `UUID` char(250) DEFAULT NULL,
  `ExtraInfoID` bigint(20) DEFAULT NULL,
  `MatchMeasure` double DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_id1` (`ID1`),
  KEY `index_startTime` (`StartTime`),
  KEY `index_plate` (`Plate`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `platetypetable`
--

DROP TABLE IF EXISTS `platetypetable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `platetypetable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `Descrizione` char(250) DEFAULT NULL,
  `TypeID` bigint(20) DEFAULT NULL,
  `Type` char(250) DEFAULT NULL,
  `PlateLayout` char(250) DEFAULT NULL,
  `Gestito` char(250) DEFAULT NULL,
  `Abilitato` char(250) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_order_epoch` (`epoch`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `run`
--

DROP TABLE IF EXISTS `run`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `run` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `id_gategroup` bigint(20) DEFAULT NULL,
  `status` char(250) DEFAULT NULL,
  `origin_type` char(250) DEFAULT NULL,
  `confirmation_required` tinyint(4) DEFAULT NULL,
  `expected_start_time` datetime DEFAULT NULL,
  `expected_end_time` datetime DEFAULT NULL,
  `confirmed_by` bigint(20) DEFAULT NULL,
  `confirmation_time` datetime DEFAULT NULL,
  `start_time` datetime DEFAULT NULL,
  `in_charge_to` bigint(20) DEFAULT NULL,
  `in_charge_to_time` datetime DEFAULT NULL,
  `terminated_by` bigint(20) DEFAULT NULL,
  `termination_type` char(250) DEFAULT NULL,
  `termination_time` datetime DEFAULT NULL,
  `termination_confirmed_time` datetime DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  `name` char(250) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `statstable`
--

DROP TABLE IF EXISTS `statstable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `statstable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `Gate` bigint(20) DEFAULT NULL,
  `Classe` char(250) DEFAULT NULL,
  `StartTime` time DEFAULT NULL,
  `EndTime` time DEFAULT NULL,
  `StartDate` date DEFAULT NULL,
  `EndDate` date DEFAULT NULL,
  `StartDateTime` datetime DEFAULT NULL,
  `EndDateTime` datetime DEFAULT NULL,
  `lengthTimeSec` bigint(20) DEFAULT NULL,
  `WeekDay` char(250) DEFAULT NULL,
  `Counter` bigint(20) DEFAULT NULL,
  `MeanSpeed` double DEFAULT NULL,
  `SpeedLimit` double DEFAULT NULL,
  `Mean` double DEFAULT NULL,
  `Variance` double DEFAULT NULL,
  `GroupID` bigint(20) DEFAULT NULL,
  `Comments` char(250) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_gate` (`Gate`),
  KEY `index_class` (`Classe`),
  KEY `index_weekday` (`WeekDay`),
  KEY `index_start_time` (`StartTime`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `statsvaluestable`
--

DROP TABLE IF EXISTS `statsvaluestable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `statsvaluestable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `StatID` bigint(20) DEFAULT NULL,
  `ValueID` bigint(20) DEFAULT NULL,
  `Counter` bigint(20) DEFAULT NULL,
  `StartValue` double DEFAULT NULL,
  `EndValue` double DEFAULT NULL,
  `Description` char(250) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `StatID` (`StatID`),
  KEY `index_statid` (`StatID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `storicotable`
--

DROP TABLE IF EXISTS `storicotable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `storicotable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `UserID` bigint(20) DEFAULT NULL,
  `EventType` char(250) DEFAULT NULL,
  `EventMode` char(250) DEFAULT NULL,
  `ModifiedBy` char(250) DEFAULT NULL,
  `EventValid` char(250) DEFAULT NULL,
  `ValidatedBy` char(250) DEFAULT NULL,
  `ValidationTime` datetime DEFAULT NULL,
  `Protocol` char(250) DEFAULT NULL,
  `NextID` bigint(20) DEFAULT NULL,
  `PreviousID` bigint(20) DEFAULT NULL,
  `TicketID` bigint(20) DEFAULT NULL,
  `Ticket` char(250) DEFAULT NULL,
  `AreaID` bigint(20) DEFAULT NULL,
  `PositionID` bigint(20) DEFAULT NULL,
  `Direction` bigint(20) DEFAULT NULL,
  `Speed` double DEFAULT NULL,
  `Classe` char(250) DEFAULT NULL,
  `Height` double DEFAULT NULL,
  `Width` double DEFAULT NULL,
  `Length` double DEFAULT NULL,
  `LaneID` bigint(20) DEFAULT NULL,
  `IsBoxComputed` bigint(20) DEFAULT NULL,
  `Gate` bigint(20) DEFAULT NULL,
  `StartTime` datetime DEFAULT NULL,
  `EndTime` datetime DEFAULT NULL,
  `Plate` char(250) DEFAULT NULL,
  `ExtPlate` char(250) DEFAULT NULL,
  `Nationality` char(250) DEFAULT NULL,
  `NetworkID` bigint(20) DEFAULT NULL,
  `Image` mediumblob,
  `ImageLength` bigint(20) DEFAULT NULL,
  `Comments` char(250) DEFAULT NULL,
  `ExtraData` mediumblob,
  `ExtraDataLength` bigint(20) DEFAULT NULL,
  `Signature` mediumblob,
  `SignatureLength` bigint(20) DEFAULT NULL,
  `UUID` char(250) DEFAULT NULL,
  `ExtraInfoID` bigint(20) DEFAULT NULL,
  `MatchMeasure` double DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  `GateDescription` char(250) DEFAULT NULL,
  `TransitComments` char(250) DEFAULT NULL,
  `GateType` char(10) DEFAULT NULL,
  `Kemler` char(250) DEFAULT NULL,
  `PlateCheck` bigint(20) DEFAULT NULL,
  `BlobFileName` char(250) DEFAULT NULL,
  `Color` char(250) DEFAULT NULL,
  `data_check` tinyint(4) DEFAULT NULL,
  `id_run` bigint(20) DEFAULT NULL,
  `id_vehicle_color` bigint(20) DEFAULT NULL,
  `data_check_time` datetime DEFAULT NULL,
  `id_data_check_user` bigint(20) DEFAULT NULL,
  `id_validate_user` bigint(20) DEFAULT NULL,
  `validation_result` varchar(255) DEFAULT NULL,
  `ext_code` varchar(255) DEFAULT NULL,
  `custom_nationality` varchar(255) DEFAULT NULL,
  `custom_vehicle_type` varchar(255) DEFAULT NULL,
  `speed_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `index_order_ext_code` (`ext_code`),
  KEY `index_order_starttime` (`StartTime`),
  KEY `index_order_plate` (`Plate`),
  KEY `index_order_protocol` (`Protocol`),
  KEY `index_order_validatedby` (`ValidatedBy`),
  KEY `index_order_gate` (`Gate`),
  KEY `index_order_uuid` (`UUID`),
  KEY `index_order_epoch` (`epoch`),
  KEY `index_order_ticketid` (`TicketID`),
  KEY `index_order_areaid` (`AreaID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tbl_migration`
--

DROP TABLE IF EXISTS `tbl_migration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbl_migration` (
  `version` varchar(255) NOT NULL,
  `apply_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`version`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `teb_table`
--

DROP TABLE IF EXISTS `teb_table`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `teb_table` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `EventID` bigint(20) DEFAULT NULL,
  `BlobData` longblob,
  `BlobDataLength` bigint(20) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  `type` char(250) DEFAULT NULL,
  `BlobID` bigint(20) DEFAULT NULL,
  `BlobIDSelected` bigint(20) DEFAULT NULL,
  `Description` char(250) DEFAULT NULL,
  `FullTime` char(250) DEFAULT NULL,
  `BlobFileName` char(250) DEFAULT NULL,
  `extrainfo` text,
  PRIMARY KEY (`ID`),
  KEY `EventID` (`EventID`),
  KEY `BlobID` (`BlobID`),
  KEY `index_order_eventid` (`EventID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `timetable`
--

DROP TABLE IF EXISTS `timetable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `timetable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `Descrizione` char(250) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_order_epoch` (`epoch`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `timezonetable`
--

DROP TABLE IF EXISTS `timezonetable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `timezonetable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `Descrizione` char(250) DEFAULT NULL,
  `WeekDay` char(250) DEFAULT NULL,
  `YearDay` char(250) DEFAULT NULL,
  `TimeStart` time DEFAULT NULL,
  `TimeStop` time DEFAULT NULL,
  `TimeID` bigint(20) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_timeid` (`TimeID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `transitextrainfotable`
--

DROP TABLE IF EXISTS `transitextrainfotable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transitextrainfotable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `Length` double DEFAULT NULL,
  `FrontPlateHeight` double DEFAULT NULL,
  `RearPlateHeight` double DEFAULT NULL,
  `BlobData` blob,
  `BlobDataLength` bigint(20) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_order_epoch` (`epoch`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_login_session`
--

DROP TABLE IF EXISTS `user_login_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_login_session` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `login_at` datetime DEFAULT NULL,
  `logout_at` datetime DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_service_session`
--

DROP TABLE IF EXISTS `user_service_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_service_session` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT NULL,
  `id_run` int(11) DEFAULT NULL,
  `event_ids` text,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(256) NOT NULL,
  `password` varchar(256) NOT NULL,
  `email` varchar(256) NOT NULL,
  `superuser` int(1) NOT NULL DEFAULT '0',
  `status` varchar(256) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_time` datetime NOT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_username` (`username`),
  UNIQUE KEY `user_email` (`email`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `usertable`
--

DROP TABLE IF EXISTS `usertable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `usertable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `Nome` char(250) DEFAULT NULL,
  `Cognome` char(250) DEFAULT NULL,
  `Note` char(250) DEFAULT NULL,
  `ID1` bigint(20) DEFAULT NULL,
  `ID2` bigint(20) DEFAULT NULL,
  `Categoria` bigint(20) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_order_epoch` (`epoch`),
  KEY `index_order_userspeciale` (`Categoria`),
  KEY `index_order_userid1` (`ID1`),
  KEY `index_order_usernome` (`Nome`),
  KEY `index_order_usercognome` (`Cognome`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `vehiclecolor`
--

DROP TABLE IF EXISTS `vehiclecolor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vehiclecolor` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `epoch` datetime DEFAULT NULL,
  `computed` tinyint(4) DEFAULT NULL,
  `c01` char(10) DEFAULT NULL,
  `c02` char(10) DEFAULT NULL,
  `c03` char(10) DEFAULT NULL,
  `c04` char(10) DEFAULT NULL,
  `c05` char(10) DEFAULT NULL,
  `c06` char(10) DEFAULT NULL,
  `c07` char(10) DEFAULT NULL,
  `c08` char(10) DEFAULT NULL,
  `c09` char(10) DEFAULT NULL,
  `c10` char(10) DEFAULT NULL,
  `c11` char(10) DEFAULT NULL,
  `c12` char(10) DEFAULT NULL,
  `c13` char(10) DEFAULT NULL,
  `c14` char(10) DEFAULT NULL,
  `c15` char(10) DEFAULT NULL,
  `c16` char(10) DEFAULT NULL,
  `c17` char(10) DEFAULT NULL,
  `scw01` double DEFAULT NULL,
  `scw02` double DEFAULT NULL,
  `scw03` double DEFAULT NULL,
  `scw04` double DEFAULT NULL,
  `scw05` double DEFAULT NULL,
  `scw06` double DEFAULT NULL,
  `scw07` double DEFAULT NULL,
  `scw08` double DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `vehicletable`
--

DROP TABLE IF EXISTS `vehicletable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vehicletable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `Descrizione` char(250) DEFAULT NULL,
  `Classe` char(250) DEFAULT NULL,
  `Abilitato` bigint(20) DEFAULT NULL,
  `AreaID` bigint(20) DEFAULT NULL,
  `Targa` char(250) DEFAULT NULL,
  `Nationality` char(250) DEFAULT NULL,
  `NetworkID` bigint(20) DEFAULT NULL,
  `UserID` bigint(20) DEFAULT NULL,
  `ID1` bigint(20) DEFAULT NULL,
  `ID2` bigint(20) DEFAULT NULL,
  `ID3` bigint(20) DEFAULT NULL,
  `ID4` bigint(20) DEFAULT NULL,
  `ID5` bigint(20) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `UserID` (`UserID`),
  KEY `index_userid` (`UserID`),
  KEY `index_plate` (`Targa`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `vehicletracetable`
--

DROP TABLE IF EXISTS `vehicletracetable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vehicletracetable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `VehicleID` char(250) DEFAULT NULL,
  `VehicleUUID` char(250) DEFAULT NULL,
  `Speed` double DEFAULT NULL,
  `MeanSpeed` double DEFAULT NULL,
  `Height` double DEFAULT NULL,
  `Width` double DEFAULT NULL,
  `Length` double DEFAULT NULL,
  `LaneID` bigint(20) DEFAULT NULL,
  `IsBoxComputed` bigint(20) NOT NULL,
  `DetectionLength` double DEFAULT NULL,
  `MinimumCameraDistance` double DEFAULT NULL,
  `MaximumCameraDistance` double DEFAULT NULL,
  `StartDateTime` datetime DEFAULT NULL,
  `StartDate` date DEFAULT NULL,
  `StartTime` time DEFAULT NULL,
  `FullStartTime` char(250) DEFAULT NULL,
  `EndDateTime` datetime DEFAULT NULL,
  `EndDate` date DEFAULT NULL,
  `EndTime` time DEFAULT NULL,
  `FullEndTime` char(250) DEFAULT NULL,
  `InterDistance` double DEFAULT NULL,
  `ClassName` char(250) DEFAULT NULL,
  `KemlerCode` char(250) DEFAULT NULL,
  `Color` char(250) DEFAULT NULL,
  `Brightness` double DEFAULT NULL,
  `Direction` char(250) DEFAULT NULL,
  `WorkingMode` char(250) DEFAULT NULL,
  `GateID` bigint(20) DEFAULT NULL,
  `Epoch` datetime DEFAULT NULL,
  `ImageBN` longblob,
  `ImageBNLength` bigint(20) DEFAULT NULL,
  `ImageBNTick` char(250) DEFAULT NULL,
  `ImageBNExtraInfo` char(250) DEFAULT NULL,
  `ImageCOL` longblob,
  `ImageCOLLength` bigint(20) DEFAULT NULL,
  `ImageCOLTick` char(250) DEFAULT NULL,
  `ImageCOLExtraInfo` char(250) DEFAULT NULL,
  `BlobFileNameBN` char(250) DEFAULT NULL,
  `BlobFileNameCOL` char(250) DEFAULT NULL,
  `Nationality` char(250) DEFAULT NULL,
  `NetworkID` bigint(20) DEFAULT NULL,
  `id_vehicle_color` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `violation_codes`
--

DROP TABLE IF EXISTS `violation_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `violation_codes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `id_behavior` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `whitelisttable`
--

DROP TABLE IF EXISTS `whitelisttable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `whitelisttable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `Descrizione` char(250) DEFAULT NULL,
  `Transito` char(250) DEFAULT NULL,
  `VehicleID` bigint(20) DEFAULT NULL,
  `GateID` bigint(20) DEFAULT NULL,
  `TimeID` bigint(20) DEFAULT NULL,
  `UserID` bigint(20) DEFAULT NULL,
  `AbbonamentoID` bigint(20) DEFAULT NULL,
  `Speciale` bigint(20) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  `Category` char(250) DEFAULT NULL,
  `Note` char(250) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `VehicleID` (`VehicleID`),
  KEY `GateID` (`GateID`),
  KEY `TimeID` (`TimeID`),
  KEY `UserID` (`UserID`),
  KEY `AbbonamentoID` (`AbbonamentoID`),
  KEY `index_vehicleid` (`VehicleID`),
  KEY `index_timeid` (`TimeID`),
  KEY `index_abbid` (`AbbonamentoID`),
  KEY `index_userid` (`UserID`),
  KEY `index_speciale` (`Speciale`),
  KEY `index_gateid` (`GateID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `ztltable`
--

DROP TABLE IF EXISTS `ztltable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ztltable` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `Descrizione` char(250) DEFAULT NULL,
  `GateID` bigint(20) DEFAULT NULL,
  `TimeID` bigint(20) DEFAULT NULL,
  `Transito` char(250) DEFAULT NULL,
  `epoch` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_gateid` (`GateID`),
  KEY `index_timeid` (`TimeID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 MAX_ROWS=1000000000;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2013-04-08 17:05:08
