<?php

class SpotSpeedArticleWizardController extends Controller
{

  public function actionView($idEventBehavior)
  {
    /**@var EventBehavior $eventBehavior */
    $eventBehavior = $this->findModel ( 'EventBehavior', $idEventBehavior, $hasGoods = null );
    /**@var Behavior $behavior */
    $behavior = $eventBehavior->behavior;
    /**@var Event $event */
    $event = $eventBehavior->event;
    /**@var ViolationCode[] $suggestedCodes */
    $suggestedCodes = array ();
    
    if ($behavior->tag != Behavior::ILLEGAL_SPOT_SPEED || SpotSpeedArticleWizard::model ()->count () <= 0)
    {
      $suggestedCodes = $behavior->violationCodes;
    }
    else
    {
      $eventForm = $_GET ['Event'];
      $requiredParams = array (
          'custom_vehicle_type',
          'custom_property_type' 
      );
      $this->ensurePresenceOfParams ( $requiredParams, $eventForm );
      
      $customVehicleType = $eventForm ['custom_vehicle_type'];
      $customPropertyType = $eventForm ['custom_property_type'];
      $challengedSpeed = CalculateChallengedSpeed::run ( $event->Speed, Yii::app ()->params ['spotSpeedViolation'] ['percentageTolerance'], Yii::app ()->params ['spotSpeedViolation'] ['fixedTolerance'], Yii::app ()->params ['spotSpeedViolation'] ['toleranceTable'] );
      $challengedSpeedDelta = $challengedSpeed - $event->speed_limit;
      $hasGoods = null;
      $dangerousGoods = $eventForm ['Kemler'];
      if (isset ( $dangerousGoods ))
      {
        $hasGoods = 0;
        if (strlen ( $dangerousGoods ) > 0)
          $hasGoods = 1;
      }
      
      $suggestedCodes = SpotSpeedArticleWizard::model ()->suggestCodes ( $customVehicleType, $customPropertyType, $challengedSpeedDelta, $event->StartTime, $hasGoods );
    }
    
    $this->renderPartial ( '_view', array (
        'eventBehavior' => $eventBehavior,
        'violationCodes' => $suggestedCodes 
    ) );
  }
}
