<?php

class DashboardController extends Controller
{
  public function actionIndex()
  {
    $user = Yii::app()->user->model;
    $gateGroups = GateGroup::getGateGroups();
    
    $workPeriods = null;
    
    if(isset($user))
    	$workPeriods = WorkPeriod::model()->byUser($user)->closed()->recently()->findAll();
    
    if(isset(Yii::app()->currentWorkPeriod))
    {
    	$currentWorkPeriod = Yii::app()->currentWorkPeriod->model;
    	if(isset($workPeriods))
    		$workPeriods = array_merge(array($currentWorkPeriod), $workPeriods);
    }
    
    $plateLists = PlateList::getCurrentUserWhiteLists();
    
    $params = array('gateGroups' => $gateGroups, 'workPeriods' => $workPeriods, 'plateLists' => $plateLists);
    $this->render('index', $params);
  }

  public function actionViewServices()
  {
    $gateGroups = GateGroup::model()->findAll();
    $this->renderPartial('_servicesTable', array('gateGroups' => $gateGroups));
  }

}
