<?php

/**
 * 
 * @author p.treu
 * @property string AppName
 * @property string MachineCode
 * @property string InstallationID
 * @property string EnviromentID
 * @property string Locality
 * @property string LogFolder
 * @property string DiagnosticFolder
 * @property string WatchDogFolder
 * @property string AlarmFolder
 * @property string DST_Folder
 * @property string Language
 * @property string ApplicationDataFolder
 * @property string EWF_HD_Driver
 * @property string ConfigCodeDrivers
 * @property string UseSoundOnConfigLoad
 * @property string WaveSound
 * @property string Country
 * @property string SysLogEnable
 * @property string SyslogToWinEvent
 * @property string SyslogIP
 * @property string SyslogPort
 * @property string KriaMachineId
 * @property string use_os_code
 * @property string GetLocalityFromAppDescr
 * @property string UpdateFolder
 * @property string GetAUsnFromApp
 * @property string AUsn
 * @property string os
 * @property string hw
 * @property string KNowPFolder
 * @property string InstallationType
 */
class MachineInfo
{

  protected $filename;

  protected $data;

  protected $text;

  public function __construct($filename = null)
  {
    if ($filename == null)
      $filename = "c:\\KRIA\\CommonDatas\\MachineInfo.ini";
    
    $this->filename = $filename;
    $this->text = file_get_contents ( $this->filename );
    $this->data = ini_string_to_array ( $this->text );
  }

  public function getMachineData()
  {
    if (isset ( $this->data ['MACHINE_DATA'] ) && is_array ( $this->data ['MACHINE_DATA'] ))
      return $this->data ['MACHINE_DATA'];
    else
      return array ();
  }

  public function __get($name)
  {
    $md = $this->getMachineData ();
    if (isset ( $md [$name] ))
      return $md [$name];
    else
      return null;
  }
}
