$(window).on('load', function () {
    if ($('.events-management-search-form').length !== 0) {
        $("#events-management-export2").prop("disabled", false);
    } else {
        $("#events-management-export2").prop("disabled", true);
    }
    if ($('.stats-violation-management-search-results').length !== 0) {
        $("#events-management-export-violations").prop("disabled", false);
    } else {
        $("#events-management-export-violations").prop("disabled", true);
    }
    if ($('.stats-operators-statistics-search-results').length !== 0) {
        $("#events-management-export-operators").prop("disabled", false);
    } else {
        $("#events-management-export-operators").prop("disabled", true);
    }
    $.getScript('../js/jszip.min.js', function ()
    {
        $.getScript('../js/FileSaver.js', function ()
        {
            exportViolationReport = function (approvedViolationsText,
                    invalidViolationsText,
                    exportedViolationsText,
                    totalViolationsText,
                    pendingViolationsText,
                    reportPartialName) {

                var fileNamePartial = "Stats_" + reportPartialName + "_from_" + $("[name='EventsStatisticsSearchForm[startDateTime]']").val() + "_to_" + $("[name='EventsStatisticsSearchForm[endDateTime]']").val();
                fileNamePartial = fileNamePartial.replace(/[\s | \/]/g, "_");
                var violationsManagementStatisticsByGates = "Descrizione;" + approvedViolationsText + ";"
                        + invalidViolationsText + ";"
                        + pendingViolationsText + ";"
                        + totalViolationsText + "\n";
                var approvedViolationsCountByGate = JSON.parse($("#approved-violations-count-by-gate-graph-data").val());
                var invalidViolationsCountByGate = JSON.parse($("#invalid-violations-count-by-gate-graph-data").val());
                var exportedEventsCountByGate = JSON.parse($("#exported-violations-count-by-gate-graph-data").val());
                $.each(JSON.parse($("#violations-count-by-gate-graph-data").val()), function (gateDescription, violationCount) {
                    violationsManagementStatisticsByGates += gateDescription + ";"
                            + approvedViolationsCountByGate[gateDescription] + ";"
                            + invalidViolationsCountByGate[gateDescription] + ";"
                            + exportedEventsCountByGate[gateDescription] + ";"
                            + violationCount + "\n";
                });
                var zip = new JSZip();
                zip.file(fileNamePartial + "_byGate.csv", violationsManagementStatisticsByGates);

                var violationsManagementStatisticsByDate = "Data;" + approvedViolationsText + ";"
                        + invalidViolationsText + ";"
                        + pendingViolationsText + ";"
                        + totalViolationsText + "\n";
                var approvedViolationsCountByDate = JSON.parse($("#approved-violations-count-by-timespan-graph-data").val());
                var invalidViolationsCountByDate = JSON.parse($("#invalid-violations-count-by-timespan-graph-data").val());
                var pendingEventsCountByDate = JSON.parse($("#pending-violations-count-by-timespan-graph-data").val());
                $.each(JSON.parse($("#violations-count-by-timespan-graph-data").val()), function (currentDate, violationCount) {
                    violationsManagementStatisticsByDate += currentDate + ";"
                            + approvedViolationsCountByDate[currentDate] + ";"
                            + invalidViolationsCountByDate[currentDate] + ";"
                            + pendingEventsCountByDate[currentDate] + ";"
                            + violationCount + "\n";
                });
                zip.file(fileNamePartial + "_byDate.csv", violationsManagementStatisticsByDate);

                var exportedStatisticsByDate = "Data;" + approvedViolationsText + ";"
                        + exportedViolationsText
                        + "\n";
                var exportedEventsCountByDate = JSON.parse($("#exported-violations-count-by-timespan-graph-data").val());
                $.each(JSON.parse($("#violations-count-by-timespan-graph-data").val()), function (currentDate) {
                    exportedStatisticsByDate += currentDate + ";"
                            + approvedViolationsCountByDate[currentDate] + ";"
                            + exportedEventsCountByDate[currentDate] + "\n";
                });
                zip.file(fileNamePartial + "_byExport.csv", exportedStatisticsByDate);

                zip.generateAsync({type: "blob"})
                        .then(function (content) {
                            // see FileSaver.js
                            saveAs(content, fileNamePartial + ".zip");
                        });

            };

            exportOperatorsReport = function (approvedViolationsText,
                    invalidViolationsText,
                    reportPartialName) {

                var fileNamePartial = "Stats_" + reportPartialName + "_from_" + $("[name='EventsStatisticsSearchForm[startDateTime]']").val() + "_to_" + $("[name='EventsStatisticsSearchForm[endDateTime]']").val();
                fileNamePartial = fileNamePartial.replace(/[\s | \/]/g, "_");

                var operatorStatisticsByDate = "Data;" + approvedViolationsText + ";"
                        + invalidViolationsText + "\n";
                var invalidViolationsCountByDate = JSON.parse($("#invalid-violations-count-by-timespan-graph-data").val());
                $.each(JSON.parse($("#approved-violations-count-by-timespan-graph-data").val()), function (currentDate, violationCount) {
                    operatorStatisticsByDate += currentDate + ";"
                            + violationCount + ";"
                            + invalidViolationsCountByDate[currentDate] + "\n";
                });


                var zip = new JSZip();
                zip.file(fileNamePartial + "_byDate.csv", operatorStatisticsByDate);

                var operatorStatisticsByUser = "Utente;" + approvedViolationsText + ";"
                        + invalidViolationsText + "\n";
                var invalidViolationsCountByUser = JSON.parse($("#users-invalid-violations-count-by-timespan-graph-data").val());
                $.each(JSON.parse($("#users-approved-violations-count-by-timespan-graph-data").val()), function (currentUser, violationCount) {
                    operatorStatisticsByUser += currentUser + ";"
                            + violationCount + ";"
                            + invalidViolationsCountByUser[currentUser] + "\n";
                });

                zip.file(fileNamePartial + "_byUser.csv", operatorStatisticsByUser);

                var operatorStatisticsByReason = "Commento;Totale\n";
                $.each(JSON.parse($("#validation-decisions-by-timespan-graph-data").val()), function (currentReason, violationCount) {
                    operatorStatisticsByReason += currentReason + ";"
                            + violationCount + "\n";
                });

                zip.file(fileNamePartial + "_byComment.csv", operatorStatisticsByUser);


                var operatorStatisticsByUserAndReason = "Commento;Totale\n";
                $.each(JSON.parse($("#users-validation-decisions-by-timespan-graph-data").val()), function (currentUser, currentUserReasonsArray) {
                    operatorStatisticsByUserAndReason = "Commento;Totale\n";
                    $.each(currentUserReasonsArray["data"], function (currentReason, reasonCount) {
                        operatorStatisticsByUserAndReason += currentReason + ";"
                                + reasonCount + "\n";
                    });
                    zip.file(fileNamePartial + "_" + currentUserReasonsArray["user"]["name"].replace(/[\s | \/]/g, "_") + ".csv", operatorStatisticsByUserAndReason);
                });


                zip.generateAsync({type: "blob"})
                        .then(function (content) {
                            // see FileSaver.js
                            saveAs(content, fileNamePartial + ".zip");
                        });

            };
        });
    });
});